/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.NoExecutionVariableScope;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti.engine.impl.persistence.entity.AbstractJobEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.calendar.CycleBusinessCalendar;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerJobEntity
extends AbstractJobEntity {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TimerJobEntity.class);

    public TimerJobEntity() {
    }

    public TimerJobEntity(TimerDeclarationImpl timerDeclaration) {
        this.jobHandlerType = timerDeclaration.getJobHandlerType();
        this.jobHandlerConfiguration = timerDeclaration.getJobHandlerConfiguration();
        this.isExclusive = timerDeclaration.isExclusive();
        this.repeat = timerDeclaration.getRepeat();
        this.retries = timerDeclaration.getRetries();
        this.jobType = "timer";
        this.revision = 1;
    }

    public TimerJobEntity(AbstractJobEntity te) {
        this.id = te.getId();
        this.jobType = te.getJobType();
        this.revision = te.getRevision();
        this.jobHandlerConfiguration = te.getJobHandlerConfiguration();
        this.jobHandlerType = te.getJobHandlerType();
        this.isExclusive = te.isExclusive();
        this.duedate = te.getDuedate();
        this.repeat = te.getRepeat();
        this.retries = te.getRetries();
        this.endDate = te.getEndDate();
        this.executionId = te.getExecutionId();
        this.processInstanceId = te.getProcessInstanceId();
        this.processDefinitionId = te.getProcessDefinitionId();
        this.exceptionMessage = te.getExceptionMessage();
        this.createTime = te.getCreateTime();
        this.setExceptionStacktrace(te.getExceptionStacktrace());
        this.setCustomValues(te.getCustomValues());
        this.tenantId = te.getTenantId();
    }

    public void execute(CommandContext commandContext) {
        this.restoreExtraData(commandContext, this.jobHandlerConfiguration);
        if (this.getDuedate() != null && !this.isValidTime(this.getDuedate())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Timer {} fired. but the dueDate is after the endDate.  Deleting timer.", (Object)this.getId());
            }
            this.delete();
            return;
        }
        ExecutionEntity execution = null;
        if (this.executionId != null) {
            execution = commandContext.getExecutionEntityManager().findExecutionById(this.executionId);
        }
        Map<String, JobHandler> jobHandlers = Context.getProcessEngineConfiguration().getJobHandlers();
        JobHandler jobHandler = jobHandlers.get(this.jobHandlerType);
        jobHandler.execute(this, this.jobHandlerConfiguration, execution, commandContext);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Timer {} fired. Deleting timer.", (Object)this.getId());
        }
        this.delete();
        this.scheduleNextTimerIfRepeat();
    }

    public void scheduleNewTimer(CommandContext commandContext) {
        this.restoreExtraData(commandContext, this.jobHandlerConfiguration);
        this.scheduleNextTimerIfRepeat();
    }

    public void scheduleNextTimerIfRepeat() {
        int repeatValue;
        if (this.repeat != null && (repeatValue = this.calculateRepeatValue()) != 0) {
            Date newTimer;
            if (repeatValue > 0) {
                this.setNewRepeat(repeatValue);
            }
            if ((newTimer = this.calculateNextTimer()) != null && this.isValidTime(newTimer)) {
                TimerJobEntity te = new TimerJobEntity(this);
                te.setDuedate(newTimer);
                te.insert();
            }
        }
    }

    public void insert() {
        Context.getCommandContext().getDbSqlSession().insert(this);
        if (this.executionId != null) {
            ExecutionEntity execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.executionId);
            execution.addTimerJob(this);
            if (execution.getTenantId() != null) {
                this.setTenantId(execution.getTenantId());
            }
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, this));
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, this));
        }
    }

    public void delete() {
        Context.getCommandContext().getDbSqlSession().delete(this);
        this.exceptionByteArrayRef.delete();
        this.customValuesByteArrayRef.delete();
        if (this.executionId != null) {
            ExecutionEntity execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.executionId);
            execution.removeTimerJob(this);
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, this));
        }
    }

    protected void restoreExtraData(CommandContext commandContext, String jobHandlerConfiguration) {
        String embededActivityId = jobHandlerConfiguration;
        if (this.jobHandlerType.equalsIgnoreCase("timer-transition") || this.jobHandlerType.equalsIgnoreCase("timer-intermediate-transition") || this.jobHandlerType.equalsIgnoreCase("timer-start-event")) {
            embededActivityId = TimerEventHandler.getActivityIdFromConfiguration(jobHandlerConfiguration);
            String endDateExpressionString = TimerEventHandler.getEndDateFromConfiguration(jobHandlerConfiguration);
            if (endDateExpressionString != null) {
                Expression endDateExpression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(endDateExpressionString);
                String endDateString = null;
                BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.getBusinessCalendarName(TimerEventHandler.geCalendarNameFromConfiguration(jobHandlerConfiguration)));
                Object executionEntity = null;
                if (this.executionId != null) {
                    executionEntity = commandContext.getExecutionEntityManager().findExecutionById(this.executionId);
                }
                if (executionEntity == null) {
                    executionEntity = NoExecutionVariableScope.getSharedInstance();
                }
                if (endDateExpression != null) {
                    Object endDateValue = endDateExpression.getValue((VariableContainer)executionEntity);
                    if (endDateValue instanceof String) {
                        endDateString = (String)endDateValue;
                    } else if (endDateValue instanceof Date) {
                        this.endDate = (Date)endDateValue;
                    } else {
                        throw new ActivitiException("Timer '" + ((ExecutionEntity)executionEntity).getActivityId() + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
                    }
                    if (this.endDate == null) {
                        this.endDate = businessCalendar.resolveEndDate(endDateString);
                    }
                }
            }
        }
        if (this.processDefinitionId != null) {
            ProcessDefinition def = Context.getProcessEngineConfiguration().getRepositoryService().getProcessDefinition(this.processDefinitionId);
            this.maxIterations = this.checkStartEventDefinitions(def, embededActivityId);
            if (this.maxIterations <= 1) {
                this.maxIterations = this.checkBoundaryEventsDefinitions(def, embededActivityId);
            }
        } else {
            this.maxIterations = 1;
        }
    }

    protected int checkStartEventDefinitions(ProcessDefinition def, String embededActivityId) {
        List startTimerDeclarations = (List)((ProcessDefinitionEntity)def).getProperty("timerStart");
        if (startTimerDeclarations != null && startTimerDeclarations.size() > 0) {
            TimerDeclarationImpl timerDeclaration = null;
            for (TimerDeclarationImpl startTimerDeclaration : startTimerDeclarations) {
                String definitionActivityId = TimerEventHandler.getActivityIdFromConfiguration(startTimerDeclaration.getJobHandlerConfiguration());
                if (!startTimerDeclaration.getJobHandlerType().equalsIgnoreCase(this.jobHandlerType) || !definitionActivityId.equalsIgnoreCase(embededActivityId)) continue;
                timerDeclaration = startTimerDeclaration;
            }
            if (timerDeclaration != null) {
                return this.calculateMaxIterationsValue(timerDeclaration.getDescription().getExpressionText());
            }
        }
        return 1;
    }

    protected int checkBoundaryEventsDefinitions(ProcessDefinition def, String embededActivityId) {
        return this.checkBoundaryEventsDefinitions(((ProcessDefinitionEntity)def).getActivities(), embededActivityId);
    }

    protected int checkBoundaryEventsDefinitions(List<ActivityImpl> activities, String embededActivityId) {
        for (ActivityImpl activity : activities) {
            List activityTimerDeclarations = (List)activity.getProperty("timerDeclarations");
            if (activityTimerDeclarations == null) continue;
            for (TimerDeclarationImpl timerDeclaration : activityTimerDeclarations) {
                String definitionActivityId = TimerEventHandler.getActivityIdFromConfiguration(timerDeclaration.getJobHandlerConfiguration());
                if (!timerDeclaration.getJobHandlerType().equalsIgnoreCase(this.jobHandlerType) || !definitionActivityId.equalsIgnoreCase(embededActivityId)) continue;
                return this.calculateMaxIterationsValue(timerDeclaration.getDescription().getExpressionText());
            }
        }
        Iterator<ActivityImpl> iterator = activities.iterator();
        if (iterator.hasNext()) {
            ActivityImpl activity;
            activity = iterator.next();
            return this.checkBoundaryEventsDefinitions(activity.getActivities(), embededActivityId);
        }
        return 1;
    }

    protected int calculateMaxIterationsValue(String originalExpression) {
        int times = Integer.MAX_VALUE;
        List<String> expression = Arrays.asList(originalExpression.split("/"));
        if (expression.size() > 1 && expression.get(0).startsWith("R")) {
            times = Integer.MAX_VALUE;
            if (expression.get(0).length() > 1) {
                times = Integer.parseInt(expression.get(0).substring(1));
            }
        }
        return times;
    }

    protected boolean isValidTime(Date newTimer) {
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.getBusinessCalendarName(TimerEventHandler.geCalendarNameFromConfiguration(this.jobHandlerConfiguration)));
        return businessCalendar.validateDuedate(this.repeat, this.maxIterations, this.endDate, newTimer);
    }

    protected int calculateRepeatValue() {
        int times = -1;
        List<String> expression = Arrays.asList(this.repeat.split("/"));
        if (expression.size() > 1 && expression.get(0).startsWith("R") && expression.get(0).length() > 1 && (times = Integer.parseInt(expression.get(0).substring(1))) > 0) {
            --times;
        }
        return times;
    }

    protected void setNewRepeat(int newRepeatValue) {
        List<String> expression = Arrays.asList(this.repeat.split("/"));
        expression = expression.subList(1, expression.size());
        StringBuilder repeatBuilder = new StringBuilder("R");
        repeatBuilder.append(newRepeatValue);
        for (String value : expression) {
            repeatBuilder.append("/");
            repeatBuilder.append(value);
        }
        this.repeat = repeatBuilder.toString();
    }

    protected Date calculateNextTimer() {
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.getBusinessCalendarName(TimerEventHandler.geCalendarNameFromConfiguration(this.jobHandlerConfiguration)));
        return businessCalendar.resolveDuedate(this.repeat, this.maxIterations);
    }

    protected String getBusinessCalendarName(String calendarName) {
        String businessCalendarName = CycleBusinessCalendar.NAME;
        if (StringUtils.isNotEmpty((CharSequence)calendarName)) {
            Object execution = NoExecutionVariableScope.getSharedInstance();
            if (StringUtils.isNotEmpty((CharSequence)this.executionId)) {
                execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.executionId);
            }
            businessCalendarName = (String)Context.getProcessEngineConfiguration().getExpressionManager().createExpression(calendarName).getValue((VariableContainer)execution);
        }
        return businessCalendarName;
    }
}

