/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.el;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.Condition;
import org.activiti.engine.impl.context.Context;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.engine.delegate.DelegateExecution;

public class UelExpressionCondition
implements Condition {
    private static final long serialVersionUID = 1L;
    protected String initialConditionExpression;

    public UelExpressionCondition(String conditionExpression) {
        this.initialConditionExpression = conditionExpression;
    }

    @Override
    public boolean evaluate(String sequenceFlowId, DelegateExecution execution) {
        String conditionExpression = null;
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode elementProperties = Context.getBpmnOverrideElementProperties(sequenceFlowId, execution.getProcessDefinitionId());
            conditionExpression = this.getActiveValue(this.initialConditionExpression, "sequenceFlowCondition", elementProperties);
        } else {
            conditionExpression = this.initialConditionExpression;
        }
        Expression expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(conditionExpression);
        Object result = expression.getValue((VariableContainer)execution);
        if (result == null) {
            throw new ActivitiException("condition expression returns null (sequenceFlowId: " + sequenceFlowId + ")");
        }
        if (!(result instanceof Boolean)) {
            throw new ActivitiException("condition expression returns non-Boolean (sequenceFlowId: " + sequenceFlowId + "): " + result + " (" + result.getClass().getName() + ")");
        }
        return (Boolean)result;
    }

    protected String getActiveValue(String originalValue, String propertyName, ObjectNode elementProperties) {
        JsonNode overrideValueNode;
        String activeValue = originalValue;
        if (elementProperties != null && (overrideValueNode = elementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : overrideValueNode.asText();
        }
        return activeValue;
    }
}

