/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import java.util.Map;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.engine.impl.bpmn.data.IOSpecification;

public class SubProcessParseHandler
extends AbstractActivityBpmnParseHandler<SubProcess> {
    @Override
    protected Class<? extends BaseElement> getHandledType() {
        return SubProcess.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, SubProcess subProcess) {
        ActivityImpl activity = this.createActivityOnScope(bpmnParse, (FlowElement)subProcess, "subProcess", bpmnParse.getCurrentScope());
        activity.setAsync(subProcess.isAsynchronous());
        activity.setExclusive(!subProcess.isNotExclusive());
        boolean triggeredByEvent = false;
        if (subProcess instanceof EventSubProcess) {
            triggeredByEvent = true;
        }
        activity.setProperty("triggeredByEvent", triggeredByEvent);
        activity.setScope(!triggeredByEvent);
        activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createSubprocActivityBehavior(subProcess));
        bpmnParse.setCurrentScope(activity);
        bpmnParse.setCurrentSubProcess(subProcess);
        bpmnParse.processFlowElements(subProcess.getFlowElements());
        this.processArtifacts(bpmnParse, subProcess.getArtifacts(), activity);
        if (!(subProcess instanceof EventSubProcess)) {
            Map<String, Object> variables = this.processDataObjects(bpmnParse, subProcess.getDataObjects(), activity);
            activity.setVariables(variables);
        }
        bpmnParse.removeCurrentScope();
        bpmnParse.removeCurrentSubProcess();
        if (subProcess.getIoSpecification() != null) {
            IOSpecification ioSpecification = this.createIOSpecification(bpmnParse, subProcess.getIoSpecification());
            activity.setIoSpecification(ioSpecification);
        }
    }
}

