/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.service.CommonServiceImpl;
import org.flowable.identitylink.service.HistoricIdentityLinkService;
import org.flowable.identitylink.service.IdentityLinkServiceConfiguration;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.api.history.HistoricTaskLogEntryQuery;
import org.flowable.task.api.history.NativeHistoricTaskLogEntryQuery;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.impl.HistoricTaskInstanceQueryImpl;
import org.flowable.task.service.impl.HistoricTaskLogEntryQueryImpl;
import org.flowable.task.service.impl.NativeHistoricTaskLogEntryQueryImpl;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntityManager;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskLogEntryEntity;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskLogEntryEntityManager;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class HistoricTaskServiceImpl
extends CommonServiceImpl<TaskServiceConfiguration>
implements HistoricTaskService {
    public HistoricTaskServiceImpl(TaskServiceConfiguration taskServiceConfiguration) {
        super((Object)taskServiceConfiguration);
    }

    @Override
    public HistoricTaskInstanceEntity getHistoricTask(String id) {
        return (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(id);
    }

    @Override
    public List<HistoricTaskInstanceEntity> findHistoricTasksByParentTaskId(String parentTaskId) {
        return this.getHistoricTaskInstanceEntityManager().findHistoricTasksByParentTaskId(parentTaskId);
    }

    @Override
    public List<String> findHistoricTaskIdsByParentTaskIds(Collection<String> parentTaskIds) {
        return this.getHistoricTaskInstanceEntityManager().findHistoricTaskIdsByParentTaskIds(parentTaskIds);
    }

    @Override
    public List<HistoricTaskInstanceEntity> findHistoricTasksByProcessInstanceId(String processInstanceId) {
        return this.getHistoricTaskInstanceEntityManager().findHistoricTasksByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<HistoricTaskInstance> findHistoricTaskInstancesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        return this.getHistoricTaskInstanceEntityManager().findHistoricTaskInstancesByQueryCriteria(historicTaskInstanceQuery);
    }

    @Override
    public HistoricTaskInstanceEntity createHistoricTask() {
        return (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().create();
    }

    @Override
    public HistoricTaskInstanceEntity createHistoricTask(TaskEntity taskEntity) {
        return this.getHistoricTaskInstanceEntityManager().create(taskEntity);
    }

    @Override
    public void updateHistoricTask(HistoricTaskInstanceEntity historicTaskInstanceEntity, boolean fireUpdateEvent) {
        this.getHistoricTaskInstanceEntityManager().update(historicTaskInstanceEntity, fireUpdateEvent);
    }

    @Override
    public void insertHistoricTask(HistoricTaskInstanceEntity historicTaskInstanceEntity, boolean fireCreateEvent) {
        this.getHistoricTaskInstanceEntityManager().insert(historicTaskInstanceEntity, fireCreateEvent);
    }

    @Override
    public void deleteHistoricTask(HistoricTaskInstanceEntity HistoricTaskInstance2) {
        this.getHistoricTaskInstanceEntityManager().delete(HistoricTaskInstance2);
    }

    @Override
    public HistoricTaskInstanceEntity recordTaskCreated(TaskEntity task) {
        HistoricTaskInstanceEntityManager historicTaskInstanceEntityManager = this.getHistoricTaskInstanceEntityManager();
        HistoricTaskInstanceEntity historicTaskInstanceEntity = historicTaskInstanceEntityManager.create(task);
        historicTaskInstanceEntityManager.insert(historicTaskInstanceEntity, true);
        return historicTaskInstanceEntity;
    }

    @Override
    public HistoricTaskInstanceEntity recordTaskEnd(TaskEntity task, String deleteReason, Date endTime) {
        HistoricTaskInstanceEntity historicTaskInstanceEntity = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(task.getId());
        if (historicTaskInstanceEntity != null) {
            historicTaskInstanceEntity.markEnded(deleteReason, endTime);
        }
        return historicTaskInstanceEntity;
    }

    @Override
    public HistoricTaskInstanceEntity recordTaskInfoChange(TaskEntity taskEntity, Date changeTime, AbstractEngineConfiguration engineConfiguration) {
        HistoricTaskInstanceEntity historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskEntity.getId());
        if (historicTaskInstance != null) {
            historicTaskInstance.setName(taskEntity.getName());
            historicTaskInstance.setDescription(taskEntity.getDescription());
            historicTaskInstance.setDueDate(taskEntity.getDueDate());
            historicTaskInstance.setPriority(taskEntity.getPriority());
            historicTaskInstance.setCategory(taskEntity.getCategory());
            historicTaskInstance.setFormKey(taskEntity.getFormKey());
            historicTaskInstance.setParentTaskId(taskEntity.getParentTaskId());
            historicTaskInstance.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
            historicTaskInstance.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
            historicTaskInstance.setClaimTime(taskEntity.getClaimTime());
            historicTaskInstance.setLastUpdateTime(changeTime);
            if (!Objects.equals(historicTaskInstance.getAssignee(), taskEntity.getAssignee())) {
                historicTaskInstance.setAssignee(taskEntity.getAssignee());
                this.createHistoricIdentityLink(historicTaskInstance.getId(), "assignee", historicTaskInstance.getAssignee(), engineConfiguration);
            }
            if (!Objects.equals(historicTaskInstance.getOwner(), taskEntity.getOwner())) {
                historicTaskInstance.setOwner(taskEntity.getOwner());
                this.createHistoricIdentityLink(historicTaskInstance.getId(), "owner", historicTaskInstance.getOwner(), engineConfiguration);
            }
        }
        return historicTaskInstance;
    }

    @Override
    public void deleteHistoricTaskLogEntry(long logNumber) {
        this.getHistoricTaskLogEntryEntityManager().deleteHistoricTaskLogEntry(logNumber);
    }

    @Override
    public void addHistoricTaskLogEntry(TaskInfo task, String logEntryType, String data) {
        if (((TaskServiceConfiguration)((Object)this.configuration)).isEnableHistoricTaskLogging()) {
            HistoricTaskLogEntryEntity taskLogEntry = (HistoricTaskLogEntryEntity)this.getHistoricTaskLogEntryEntityManager().create();
            taskLogEntry.setTaskId(task.getId());
            taskLogEntry.setExecutionId(task.getExecutionId());
            taskLogEntry.setProcessInstanceId(task.getProcessInstanceId());
            taskLogEntry.setProcessDefinitionId(task.getProcessDefinitionId());
            taskLogEntry.setScopeId(task.getScopeId());
            taskLogEntry.setScopeDefinitionId(task.getScopeDefinitionId());
            taskLogEntry.setScopeType(task.getScopeType());
            taskLogEntry.setSubScopeId(task.getSubScopeId());
            taskLogEntry.setTimeStamp(((TaskServiceConfiguration)((Object)this.configuration)).getClock().getCurrentTime());
            taskLogEntry.setType(logEntryType);
            taskLogEntry.setData(data);
            taskLogEntry.setUserId(Authentication.getAuthenticatedUserId());
            this.getHistoricTaskLogEntryEntityManager().insert(taskLogEntry);
        }
    }

    @Override
    public void createHistoricTaskLogEntry(HistoricTaskLogEntryBuilder historicTaskLogEntryBuilder) {
        if (((TaskServiceConfiguration)((Object)this.configuration)).isEnableHistoricTaskLogging()) {
            this.getHistoricTaskLogEntryEntityManager().createHistoricTaskLogEntry(historicTaskLogEntryBuilder);
        }
    }

    @Override
    public HistoricTaskLogEntryQuery createHistoricTaskLogEntryQuery(CommandExecutor commandExecutor) {
        return new HistoricTaskLogEntryQueryImpl(commandExecutor, (TaskServiceConfiguration)((Object)this.configuration));
    }

    @Override
    public void deleteHistoricTaskLogEntriesForProcessDefinition(String processDefinitionId) {
        if (((TaskServiceConfiguration)((Object)this.configuration)).isEnableHistoricTaskLogging()) {
            this.getHistoricTaskLogEntryEntityManager().deleteHistoricTaskLogEntriesForProcessDefinition(processDefinitionId);
        }
    }

    @Override
    public void deleteHistoricTaskLogEntriesForScopeDefinition(String scopeType, String scopeDefinitionId) {
        if (((TaskServiceConfiguration)((Object)this.configuration)).isEnableHistoricTaskLogging()) {
            this.getHistoricTaskLogEntryEntityManager().deleteHistoricTaskLogEntriesForScopeDefinition(scopeType, scopeDefinitionId);
        }
    }

    @Override
    public void deleteHistoricTaskLogEntriesForTaskId(String taskId) {
        if (((TaskServiceConfiguration)((Object)this.configuration)).isEnableHistoricTaskLogging()) {
            this.getHistoricTaskLogEntryEntityManager().deleteHistoricTaskLogEntriesForTaskId(taskId);
        }
    }

    @Override
    public void bulkDeleteHistoricTaskLogEntriesForTaskIds(Collection<String> taskIds) {
        if (((TaskServiceConfiguration)((Object)this.configuration)).isEnableHistoricTaskLogging()) {
            this.getHistoricTaskLogEntryEntityManager().bulkDeleteHistoricTaskLogEntriesForTaskIds(taskIds);
        }
    }

    @Override
    public void deleteHistoricTaskLogEntriesForNonExistingProcessInstances() {
        if (((TaskServiceConfiguration)((Object)this.configuration)).isEnableHistoricTaskLogging()) {
            this.getHistoricTaskLogEntryEntityManager().deleteHistoricTaskLogEntriesForNonExistingProcessInstances();
        }
    }

    @Override
    public void deleteHistoricTaskLogEntriesForNonExistingCaseInstances() {
        if (((TaskServiceConfiguration)((Object)this.configuration)).isEnableHistoricTaskLogging()) {
            this.getHistoricTaskLogEntryEntityManager().deleteHistoricTaskLogEntriesForNonExistingCaseInstances();
        }
    }

    @Override
    public void deleteHistoricTaskInstances(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        this.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstances(historicTaskInstanceQuery);
    }

    @Override
    public void bulkDeleteHistoricTaskInstances(Collection<String> taskIds) {
        this.getHistoricTaskInstanceEntityManager().bulkDeleteHistoricTaskInstancesForIds(taskIds);
    }

    @Override
    public void deleteHistoricTaskInstancesForNonExistingProcessInstances() {
        this.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstancesForNonExistingProcessInstances();
    }

    @Override
    public void deleteHistoricTaskInstancesForNonExistingCaseInstances() {
        this.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstancesForNonExistingCaseInstances();
    }

    @Override
    public NativeHistoricTaskLogEntryQuery createNativeHistoricTaskLogEntryQuery(CommandExecutor commandExecutor) {
        return new NativeHistoricTaskLogEntryQueryImpl(commandExecutor, (TaskServiceConfiguration)((Object)this.configuration));
    }

    protected HistoricTaskLogEntryEntityManager getHistoricTaskLogEntryEntityManager() {
        return ((TaskServiceConfiguration)((Object)this.configuration)).getHistoricTaskLogEntryEntityManager();
    }

    protected void createHistoricIdentityLink(String taskId, String type, String userId, AbstractEngineConfiguration engineConfiguration) {
        HistoricIdentityLinkService historicIdentityLinkService = this.getIdentityLinkServiceConfiguration(engineConfiguration).getHistoricIdentityLinkService();
        HistoricIdentityLinkEntity historicIdentityLinkEntity = historicIdentityLinkService.createHistoricIdentityLink();
        historicIdentityLinkEntity.setTaskId(taskId);
        historicIdentityLinkEntity.setType(type);
        historicIdentityLinkEntity.setUserId(userId);
        historicIdentityLinkEntity.setCreateTime(((TaskServiceConfiguration)((Object)this.configuration)).getClock().getCurrentTime());
        historicIdentityLinkService.insertHistoricIdentityLink(historicIdentityLinkEntity, false);
    }

    public HistoricTaskInstanceEntityManager getHistoricTaskInstanceEntityManager() {
        return ((TaskServiceConfiguration)((Object)this.configuration)).getHistoricTaskInstanceEntityManager();
    }

    protected IdentityLinkServiceConfiguration getIdentityLinkServiceConfiguration(AbstractEngineConfiguration engineConfiguration) {
        return (IdentityLinkServiceConfiguration)engineConfiguration.getServiceConfigurations().get("cfg.identityLinkService");
    }
}

