/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.el.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flowable.dmn.engine.impl.el.util.DateUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNParseUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DMNParseUtil.class);

    public static boolean isCollection(Object collection) {
        return DMNParseUtil.isJavaCollection(collection) || DMNParseUtil.isArrayNode(collection);
    }

    public static boolean isJavaCollection(Object collection) {
        return Collection.class.isAssignableFrom(collection.getClass());
    }

    public static boolean isArrayNode(Object collection) {
        return ArrayNode.class.isAssignableFrom(collection.getClass());
    }

    public static boolean isParseableCollection(Object value) {
        if (!(value instanceof String) || "".equals(value)) {
            return false;
        }
        String stringValue = String.valueOf(value);
        return stringValue.contains(",");
    }

    public static Collection parseCollection(Object value, Object targetType) {
        String stringValue = String.valueOf(value);
        Class<?> collectionType = DMNParseUtil.getTargetType(targetType);
        if (stringValue.startsWith("[") && stringValue.endsWith("]")) {
            stringValue = stringValue.substring(1, stringValue.length() - 1);
        }
        List<Object> items = DMNParseUtil.split(stringValue, collectionType);
        return items;
    }

    public static Collection getCollectionFromArrayNode(ArrayNode arrayNode) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (JsonNode node : arrayNode) {
            values.add(DMNParseUtil.getJsonValue(node));
        }
        return values;
    }

    protected static Object getJsonValue(JsonNode jsonNode) {
        switch (jsonNode.getNodeType()) {
            case ARRAY: {
                LOGGER.warn("Nested ArrayNodes not supported");
            }
            case BINARY: {
                LOGGER.warn("Nested BinaryNodes not supported");
            }
            case OBJECT: {
                LOGGER.warn("Nested ObjectNodes not supported");
            }
            case POJO: {
                LOGGER.warn("Nested PojoNodes not supported");
            }
            case BOOLEAN: {
                return jsonNode.booleanValue();
            }
            case NULL: {
                return null;
            }
            case NUMBER: {
                return DMNParseUtil.getNumberValue(jsonNode.numberValue().toString());
            }
        }
        return jsonNode.textValue();
    }

    protected static List<Object> split(String str, Class<?> collectionType) {
        String regex = str.contains("\"") ? ",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)" : ",";
        return Stream.of(str.split(regex)).map(elem -> DMNParseUtil.formatElementValue(elem.trim(), collectionType)).collect(Collectors.toList());
    }

    protected static Object getFormattedValue(Object value, Object inputCollection) {
        Class<?> collectionType = DMNParseUtil.getTargetType(inputCollection);
        return DMNParseUtil.formatElementValue(value, collectionType);
    }

    protected static Object formatElementValue(Object value, Class<?> collectionType) {
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.isEmpty()) {
                return null;
            }
            value = DMNParseUtil.removedSurroundingQuotes(stringValue);
        }
        if (Date.class.equals(collectionType)) {
            return DateUtil.toDate(value.toString());
        }
        if (LocalDate.class.equals(collectionType)) {
            return new DateTime((Object)DateUtil.toDate(value)).toLocalDate();
        }
        if (Integer.class.equals(collectionType) || Long.class.equals(collectionType) || Float.class.equals(collectionType) || Double.class.equals(collectionType)) {
            return DMNParseUtil.getNumberValue(value.toString(), collectionType);
        }
        if (Boolean.class.equals(collectionType)) {
            return Boolean.valueOf(value.toString());
        }
        return value;
    }

    protected static String removedSurroundingQuotes(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    protected static Object getNumberValue(String value, Class<?> targetType) {
        Number returnValue = null;
        try {
            returnValue = Integer.class.equals(targetType) ? (Number)Integer.valueOf(value) : (Number)(Long.class.equals(targetType) ? (Number)Long.valueOf(value) : (Number)(Float.class.equals(targetType) ? (Number)Float.valueOf(value) : (Number)Double.valueOf(value)));
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn("Could not parse to Integer, Long, Float or Double from: {}", (Object)value);
        }
        return returnValue;
    }

    protected static Object getNumberValue(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe1) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException nfe2) {
                LOGGER.warn("Could not parse to Long or Double from: {}", (Object)value);
                return null;
            }
        }
    }

    protected static Class<?> getTargetType(Object targetTypeObject) {
        if (targetTypeObject == null) {
            return null;
        }
        if (DMNParseUtil.isJavaCollection(targetTypeObject)) {
            if (((Collection)targetTypeObject).isEmpty()) {
                return null;
            }
            return ((Collection)targetTypeObject).iterator().next().getClass();
        }
        return targetTypeObject.getClass();
    }
}

