/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.engine.impl.DecisionTableQueryImpl;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;

public class SetDeploymentTenantIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String newTenantId;

    public SetDeploymentTenantIdCmd(String deploymentId, String newTenantId) {
        this.deploymentId = deploymentId;
        this.newTenantId = newTenantId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new FlowableIllegalArgumentException("deploymentId is null");
        }
        DmnDeploymentEntity deployment = (DmnDeploymentEntity)CommandContextUtil.getDeploymentEntityManager(commandContext).findById(this.deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find deployment with id " + this.deploymentId);
        }
        deployment.setTenantId(this.newTenantId);
        CommandContextUtil.getDecisionTableEntityManager(commandContext).updateDecisionTableTenantIdForDeployment(this.deploymentId, this.newTenantId);
        List decisionTables = new DecisionTableQueryImpl().deploymentId(this.deploymentId).list();
        for (DmnDecisionTable decisionTable : decisionTables) {
            CommandContextUtil.getDmnEngineConfiguration().getDecisionCache().remove(decisionTable.getId());
        }
        CommandContextUtil.getDeploymentEntityManager(commandContext).update(deployment);
        return null;
    }
}

