/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.ConfigurationParameter;
import fitnesse.wiki.PageData;
import fitnesse.wiki.RecentChanges;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.fs.DiskFileSystem;
import fitnesse.wiki.fs.FileBasedWikiPage;
import fitnesse.wiki.fs.FileSystem;
import fitnesse.wiki.fs.FileVersion;
import fitnesse.wiki.fs.GitRecentChangesPage;
import fitnesse.wiki.fs.LogCommandSpec;
import fitnesse.wiki.fs.SimpleFileVersionsController;
import fitnesse.wiki.fs.VersionsController;
import fitnesse.wiki.fs.WikiPageProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.TreeWalk;

public class GitFileVersionsController
implements VersionsController,
RecentChanges {
    private static final int RECENT_CHANGES_DEPTH = 100;
    private final SimpleFileVersionsController persistence;
    private final int historyDepth;

    public GitFileVersionsController(Properties properties) {
        this(GitFileVersionsController.getVersionDays(properties));
    }

    public GitFileVersionsController(int historyDepth) {
        this.historyDepth = historyDepth;
        this.persistence = new SimpleFileVersionsController((FileSystem)new DiskFileSystem());
    }

    public GitFileVersionsController() {
        this(14);
    }

    private static int getVersionDays(Properties properties) {
        String days = properties.getProperty(ConfigurationParameter.VERSIONS_CONTROLLER_DAYS.getKey());
        return days == null ? 14 : Integer.parseInt(days);
    }

    public FileVersion[] getRevisionData(String label, File ... files) {
        if (label == null) {
            return this.persistence.getRevisionData(null, files);
        }
        Repository repository = GitFileVersionsController.getRepository(files[0]);
        FileVersion[] versions = new FileVersion[files.length];
        try {
            ObjectId rev = repository.resolve(label);
            RevWalk walk = new RevWalk(repository);
            RevCommit revCommit = walk.parseCommit((AnyObjectId)rev);
            PersonIdent author = revCommit.getAuthorIdent();
            int counter = 0;
            for (File file : files) {
                String path = this.getPath(file, repository);
                byte[] content = this.getRepositoryContent(repository, revCommit, path);
                versions[counter++] = new GitFileVersion(file, content, author.getName(), author.getWhen());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get data for revision " + label, e);
        }
        return versions;
    }

    private byte[] getRepositoryContent(Repository repository, RevCommit revCommit, String fileName) throws IOException {
        TreeWalk treewalk = TreeWalk.forPath((Repository)repository, (String)fileName, (RevTree)revCommit.getTree());
        if (treewalk != null) {
            return repository.open((AnyObjectId)treewalk.getObjectId(0)).getBytes();
        }
        return null;
    }

    public Collection<VersionInfo> history(final File ... files) {
        try {
            return this.history(files[0], new LogCommandSpec(){

                @Override
                public LogCommand specify(LogCommand log, Repository repository) {
                    for (File file : files) {
                        try {
                            log.addPath(GitFileVersionsController.this.getPath(file, repository));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return log.setMaxCount(GitFileVersionsController.this.historyDepth);
                }
            });
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<VersionInfo> history(File file, LogCommandSpec logCommandSpec) throws GitAPIException {
        Repository repository = GitFileVersionsController.getRepository(file);
        Git git = new Git(repository);
        Iterable log = logCommandSpec.specify(git.log(), repository).call();
        ArrayList<VersionInfo> versions = new ArrayList<VersionInfo>(this.historyDepth);
        for (RevCommit revCommit : log) {
            versions.add(this.makeVersionInfo(revCommit));
        }
        return versions;
    }

    public VersionInfo makeVersion(FileVersion ... fileVersions) throws IOException {
        this.persistence.makeVersion(fileVersions);
        Repository repository = GitFileVersionsController.getRepository(fileVersions[0].getFile());
        Git git = new Git(repository);
        try {
            AddCommand adder = git.add();
            for (FileVersion fileVersion : fileVersions) {
                adder.addFilepattern(this.getPath(fileVersion.getFile(), repository));
            }
            adder.call();
            this.commit(git, String.format("[FitNesse] Updated files: %s.", this.formatFileVersions(fileVersions)), fileVersions[0].getAuthor());
        }
        catch (GitAPIException e) {
            throw new IOException("Unable to commit changes", e);
        }
        return VersionInfo.makeVersionInfo((String)fileVersions[0].getAuthor(), (Date)fileVersions[0].getLastModificationTime());
    }

    public void delete(File ... files) throws IOException {
        Repository repository = GitFileVersionsController.getRepository(files[0]);
        Git git = new Git(repository);
        try {
            RmCommand remover = git.rm();
            for (File file : files) {
                remover.addFilepattern(this.getPath(file, repository));
            }
            remover.call();
            this.commit(git, String.format("[FitNesse] Deleted files: %s.", this.formatFiles(files)), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.persistence.delete(files);
    }

    private String formatFileVersions(FileVersion[] fileVersions) {
        File[] files = new File[fileVersions.length];
        int counter = 0;
        for (FileVersion fileVersion : fileVersions) {
            files[counter++] = fileVersion.getFile();
        }
        return this.formatFiles(files);
    }

    String formatFiles(File[] files) {
        StringBuilder builder = new StringBuilder(128);
        int counter = 0;
        for (File file : files) {
            if (counter > 0) {
                builder.append(counter == files.length - 1 ? " and " : ", ");
            }
            builder.append(file.getPath());
            ++counter;
        }
        return builder.toString();
    }

    private void commit(Git git, String message, String author) throws GitAPIException {
        Status status = git.status().call();
        if (!(status.getAdded().isEmpty() && status.getChanged().isEmpty() && status.getRemoved().isEmpty())) {
            if (author == null) {
                author = "";
            }
            git.commit().setAuthor(author, "").setMessage(message).call();
        }
    }

    private String getPath(File file, Repository repository) throws IOException {
        String workTreePath = repository.getWorkTree().getCanonicalPath();
        String pagePath = file.getCanonicalPath();
        assert (pagePath.startsWith(workTreePath));
        pagePath = pagePath.substring(workTreePath.length());
        if ((pagePath = pagePath.replace(File.separatorChar, '/')).startsWith("/")) {
            pagePath = pagePath.substring(1);
        }
        return pagePath;
    }

    private GitVersionInfo makeVersionInfo(RevCommit revCommit) {
        PersonIdent authorIdent = revCommit.getAuthorIdent();
        return new GitVersionInfo(revCommit.name(), authorIdent.getName(), authorIdent.getWhen(), revCommit.getShortMessage());
    }

    public static Repository getRepository(File file) {
        try {
            return ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(file.getCanonicalFile())).readEnvironment()).setMustExist(true)).build();
        }
        catch (IOException e) {
            throw new RuntimeException("No Git repository found", e);
        }
    }

    public void updateRecentChanges(WikiPage page) {
    }

    public WikiPage toWikiPage(WikiPage root) {
        String content;
        FileBasedWikiPage fsPage = (FileBasedWikiPage)root;
        try {
            content = this.convertToWikiText(this.history(fsPage.getFileSystemPath(), new LogCommandSpec(){

                @Override
                public LogCommand specify(LogCommand log, Repository repository) {
                    return log.setMaxCount(100);
                }
            }));
        }
        catch (GitAPIException e) {
            content = "Unable to read history: " + e.getMessage();
        }
        return new GitRecentChangesPage("RecentChanges", root, new PageData(content, (WikiPageProperty)new WikiPageProperties()));
    }

    private String convertToWikiText(Collection<VersionInfo> history) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("kk:mm:ss EEE, MMM dd, yyyy");
        StringBuilder builder = new StringBuilder(1024);
        for (VersionInfo versionInfo : history) {
            builder.append("|").append(((GitVersionInfo)versionInfo).getComment()).append("|").append(versionInfo.getAuthor()).append("|").append(dateFormat.format(versionInfo.getCreationTime())).append("|\n");
        }
        return builder.toString();
    }

    public VersionInfo addDirectory(FileVersion dir) throws IOException {
        return this.persistence.addDirectory(dir);
    }

    public void rename(FileVersion fileVersion, File oldFile) throws IOException {
        File renameTo = fileVersion.getFile();
        Repository repository = GitFileVersionsController.getRepository(renameTo);
        this.persistence.rename(fileVersion, oldFile);
        Git git = new Git(repository);
        try {
            git.add().addFilepattern(this.getPath(renameTo, repository)).call();
            git.rm().addFilepattern(this.getPath(oldFile, repository)).call();
            this.commit(git, String.format("[FitNesse] Renamed file %s to %s.", oldFile.getPath(), renameTo.getPath()), fileVersion.getAuthor());
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    private static class GitFileVersion
    implements FileVersion {
        private final File file;
        private final byte[] content;
        private final String author;
        private final Date lastModified;

        public GitFileVersion(File file, byte[] content, String author, Date modified) {
            this.file = file;
            this.content = content;
            this.author = author;
            this.lastModified = modified;
        }

        public File getFile() {
            return this.file;
        }

        public InputStream getContent() throws IOException {
            return new ByteArrayInputStream(this.content);
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getLastModificationTime() {
            return this.lastModified;
        }
    }

    private static class GitVersionInfo
    extends VersionInfo {
        private final String comment;

        private GitVersionInfo(String name, String author, Date creationTime, String comment) {
            super(name, author, creationTime);
            this.comment = comment;
        }

        private String getComment() {
            return this.comment;
        }
    }
}

