/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.fields.RowValueBuilder;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.TypeMetadata;
import org.firebirdsql.util.FirebirdSupportInfo;

public abstract class GetFunctionColumns {
    private static final RowDescriptor FUNCTION_COLUMNS_ROW_DESCRIPTOR = new RowDescriptorBuilder(17, DbMetadataMediator.datatypeCoder).at(0).simple(449, 63, "FUNCTION_CAT", "FUNCTION_COLUMNS").addField().at(1).simple(449, 63, "FUNCTION_SCHEM", "FUNCTION_COLUMNS").addField().at(2).simple(448, 63, "FUNCTION_NAME", "FUNCTION_COLUMNS").addField().at(3).simple(448, 63, "COLUMN_NAME", "FUNCTION_COLUMNS").addField().at(4).simple(500, 0, "COLUMN_TYPE", "FUNCTION_COLUMNS").addField().at(5).simple(496, 0, "DATA_TYPE", "FUNCTION_COLUMNS").addField().at(6).simple(448, 63, "TYPE_NAME", "FUNCTION_COLUMNS").addField().at(7).simple(497, 0, "PRECISION", "FUNCTION_COLUMNS").addField().at(8).simple(496, 0, "LENGTH", "FUNCTION_COLUMNS").addField().at(9).simple(501, 0, "SCALE", "FUNCTION_COLUMNS").addField().at(10).simple(500, 0, "RADIX", "FUNCTION_COLUMNS").addField().at(11).simple(500, 0, "NULLABLE", "FUNCTION_COLUMNS").addField().at(12).simple(449, Integer.MAX_VALUE, "REMARKS", "FUNCTION_COLUMNS").addField().at(13).simple(497, 0, "CHAR_OCTET_LENGTH", "FUNCTION_COLUMNS").addField().at(14).simple(496, 0, "ORDINAL_POSITION", "FUNCTION_COLUMNS").addField().at(15).simple(448, 3, "IS_NULLABLE", "FUNCTION_COLUMNS").addField().at(16).simple(448, 63, "SPECIFIC_NAME", "FUNCTION_COLUMNS").addField().toRowDescriptor();
    private final DbMetadataMediator mediator;

    private GetFunctionColumns(DbMetadataMediator mediator) {
        this.mediator = mediator;
    }

    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        if ("".equals(functionNamePattern) || "".equals(columnNamePattern)) {
            return new FBResultSet(FUNCTION_COLUMNS_ROW_DESCRIPTOR, Collections.emptyList());
        }
        DbMetadataMediator.MetadataQuery metadataQuery = this.createGetFunctionColumnsQuery(functionNamePattern, columnNamePattern);
        try (ResultSet rs = this.mediator.performMetaDataQuery(metadataQuery);){
            if (!rs.next()) {
                FBResultSet fBResultSet = new FBResultSet(FUNCTION_COLUMNS_ROW_DESCRIPTOR, Collections.emptyList());
                return fBResultSet;
            }
            byte[] functionColumnIn = this.mediator.createShort(1);
            byte[] functionColumnReturn = this.mediator.createShort(4);
            byte[] functionNoNulls = this.mediator.createShort(0);
            byte[] functionNullable = this.mediator.createShort(1);
            byte[] nullableYes = this.mediator.createString("YES");
            byte[] nullableNo = this.mediator.createString("NO");
            ArrayList<RowValue> rows = new ArrayList<RowValue>();
            RowValueBuilder valueBuilder = new RowValueBuilder(FUNCTION_COLUMNS_ROW_DESCRIPTOR);
            do {
                byte[] functionNameBytes = this.mediator.createString(rs.getString("FUNCTION_NAME"));
                TypeMetadata typeMetadata = TypeMetadata.builder(this.mediator.getFirebirdSupportInfo()).withType(rs.getObject("FIELD_TYPE", Integer.class)).withSubType(rs.getObject("FIELD_SUB_TYPE", Integer.class)).withPrecision(rs.getObject("FIELD_PRECISION", Integer.class)).withScale(rs.getObject("FIELD_SCALE", Integer.class)).withFieldLength(rs.getObject("FIELD_LENGTH", Integer.class)).withCharacterLength(rs.getObject("CHARACTER_LENGTH", Integer.class)).withCharacterSetId(rs.getObject("CHARACTER_SET_ID", Integer.class)).build();
                int ordinalPosition = rs.getInt("ORDINAL_POSITION");
                boolean nullable = rs.getBoolean("IS_NULLABLE");
                valueBuilder.at(0).set(null).at(1).set(null).at(2).set(functionNameBytes).at(3).set(this.mediator.createString(rs.getString("COLUMN_NAME"))).at(4).set(ordinalPosition == 0 ? functionColumnReturn : functionColumnIn).at(5).set(this.mediator.createInt(typeMetadata.getJdbcType())).at(6).set(this.mediator.createString(typeMetadata.getSqlTypeName())).at(7).set(this.mediator.createInt(typeMetadata.getColumnSize())).at(8).set(this.mediator.createInt(typeMetadata.getLength())).at(9).set(this.mediator.createShort(typeMetadata.getScale())).at(10).set(this.mediator.createShort(typeMetadata.getRadix())).at(11).set(nullable ? functionNullable : functionNoNulls).at(12).set(null).at(13).set(this.mediator.createInt(typeMetadata.getCharOctetLength())).at(14).set(this.mediator.createInt(ordinalPosition)).at(15).set(nullable ? nullableYes : nullableNo).at(16).set(functionNameBytes);
                rows.add(valueBuilder.toRowValue(false));
            } while (rs.next());
            FBResultSet fBResultSet = new FBResultSet(FUNCTION_COLUMNS_ROW_DESCRIPTOR, rows);
            return fBResultSet;
        }
    }

    abstract DbMetadataMediator.MetadataQuery createGetFunctionColumnsQuery(String var1, String var2);

    public static GetFunctionColumns create(DbMetadataMediator mediator) {
        FirebirdSupportInfo firebirdSupportInfo = mediator.getFirebirdSupportInfo();
        if (firebirdSupportInfo.isVersionEqualOrAbove(3, 0)) {
            return new GetFunctionColumnsFirebird3_0(mediator);
        }
        return new GetFunctionColumnsFirebird2_5(mediator);
    }

    private static class GetFunctionColumnsFirebird3_0
    extends GetFunctionColumns {
        private static final String GET_FUNCTION_COLUMNS_FRAGMENT_3_0 = "select\n  trim(trailing from FUN.RDB$FUNCTION_NAME) as FUNCTION_NAME,\n  -- legacy UDF and return value have no parameter name: derive one\n  coalesce(FUNA.RDB$ARGUMENT_NAME, 'PARAM_' || FUNA.RDB$ARGUMENT_POSITION) as COLUMN_NAME,\n  coalesce(FUNA.RDB$FIELD_TYPE, F.RDB$FIELD_TYPE) as FIELD_TYPE,\n  coalesce(FUNA.RDB$FIELD_SUB_TYPE, F.RDB$FIELD_SUB_TYPE) as FIELD_SUB_TYPE,\n  coalesce(FUNA.RDB$FIELD_PRECISION, F.RDB$FIELD_PRECISION) AS FIELD_PRECISION,\n  coalesce(FUNA.RDB$FIELD_SCALE, F.RDB$FIELD_SCALE) as FIELD_SCALE,\n  coalesce(FUNA.RDB$FIELD_LENGTH, F.RDB$FIELD_LENGTH) as FIELD_LENGTH,\n  coalesce(FUNA.RDB$CHARACTER_LENGTH, F.RDB$CHARACTER_LENGTH) as \"CHARACTER_LENGTH\",\n  coalesce(FUNA.RDB$CHARACTER_SET_ID, F.RDB$CHARACTER_SET_ID) as CHARACTER_SET_ID,\n  case\n    when FUN.RDB$RETURN_ARGUMENT = FUNA.RDB$ARGUMENT_POSITION then 0\n    else FUNA.RDB$ARGUMENT_POSITION\n  end as ORDINAL_POSITION,\n  case \n    when coalesce(FUNA.RDB$NULL_FLAG, F.RDB$NULL_FLAG) = 1 then false\n    when FUNA.RDB$MECHANISM = 0 then false\n    when FUNA.RDB$MECHANISM = 1 then false\n    else true\n  end as IS_NULLABLE\nfrom RDB$FUNCTIONS FUN\ninner join RDB$FUNCTION_ARGUMENTS FUNA\n  on FUNA.RDB$FUNCTION_NAME = FUN.RDB$FUNCTION_NAME \n    and FUNA.RDB$PACKAGE_NAME is not distinct from FUN.RDB$PACKAGE_NAME\nleft join RDB$FIELDS F\n  on F.RDB$FIELD_NAME = FUNA.RDB$FIELD_SOURCE\nwhere FUN.RDB$PACKAGE_NAME is null\n";
        private static final String GET_FUNCTION_COLUMNS_ORDER_BY_3_0 = "order by FUN.RDB$PACKAGE_NAME, FUN.RDB$FUNCTION_NAME,\n  case\n    when FUN.RDB$RETURN_ARGUMENT = FUNA.RDB$ARGUMENT_POSITION then -1\n    else FUNA.RDB$ARGUMENT_POSITION\n  end";

        private GetFunctionColumnsFirebird3_0(DbMetadataMediator mediator) {
            super(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetFunctionColumnsQuery(String functionNamePattern, String columnNamePattern) {
            Clause functionNameClause = new Clause("FUN.RDB$FUNCTION_NAME", functionNamePattern);
            Clause columnNameClause = new Clause("coalesce(FUNA.RDB$ARGUMENT_NAME, 'PARAM_' || FUNA.RDB$ARGUMENT_POSITION)", columnNamePattern);
            String query = GET_FUNCTION_COLUMNS_FRAGMENT_3_0 + functionNameClause.getCondition("and ", "\n") + columnNameClause.getCondition("and ", "\n") + GET_FUNCTION_COLUMNS_ORDER_BY_3_0;
            return new DbMetadataMediator.MetadataQuery(query, Clause.parameters(functionNameClause, columnNameClause));
        }
    }

    private static class GetFunctionColumnsFirebird2_5
    extends GetFunctionColumns {
        private static final String GET_FUNCTION_COLUMNS_FRAGMENT_2_5 = "select\n  trim(trailing from FUN.RDB$FUNCTION_NAME) as FUNCTION_NAME,\n  -- Firebird 2.5 and earlier have no parameter name: derive one\n  'PARAM_' || FUNA.RDB$ARGUMENT_POSITION as COLUMN_NAME,\n  FUNA.RDB$FIELD_TYPE as FIELD_TYPE,\n  FUNA.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE,\n  FUNA.RDB$FIELD_PRECISION AS FIELD_PRECISION,\n  FUNA.RDB$FIELD_SCALE as FIELD_SCALE,\n  FUNA.RDB$FIELD_LENGTH as FIELD_LENGTH,\n  FUNA.RDB$CHARACTER_LENGTH as \"CHARACTER_LENGTH\",\n  FUNA.RDB$CHARACTER_SET_ID as CHARACTER_SET_ID,\n  case\n    when FUN.RDB$RETURN_ARGUMENT = FUNA.RDB$ARGUMENT_POSITION then 0\n    else FUNA.RDB$ARGUMENT_POSITION\n  end as ORDINAL_POSITION,\n  case FUNA.RDB$MECHANISM\n    when 0 then 'F'\n    when 1 then 'F'\n    else 'T'\n  end as IS_NULLABLE\nfrom RDB$FUNCTIONS FUN\ninner join RDB$FUNCTION_ARGUMENTS FUNA\n  on FUNA.RDB$FUNCTION_NAME = FUN.RDB$FUNCTION_NAME\n";
        private static final String GET_FUNCTION_COLUMNS_ORDER_BY_2_5 = "order by FUN.RDB$FUNCTION_NAME,\n  case\n    when FUN.RDB$RETURN_ARGUMENT = FUNA.RDB$ARGUMENT_POSITION then -1\n    else FUNA.RDB$ARGUMENT_POSITION\n  end";

        private GetFunctionColumnsFirebird2_5(DbMetadataMediator mediator) {
            super(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetFunctionColumnsQuery(String functionNamePattern, String columnNamePattern) {
            Clause functionNameClause = new Clause("FUN.RDB$FUNCTION_NAME", functionNamePattern);
            Clause columnNameClause = new Clause("'PARAM_' || FUNA.RDB$ARGUMENT_POSITION", columnNamePattern);
            String query = GET_FUNCTION_COLUMNS_FRAGMENT_2_5 + (Clause.anyCondition(functionNameClause, columnNameClause) ? "where " + functionNameClause.getCondition("", columnNameClause.hasCondition() ? "\nand " : "\n") + columnNameClause.getCondition("", "\n") : "") + GET_FUNCTION_COLUMNS_ORDER_BY_2_5;
            return new DbMetadataMediator.MetadataQuery(query, Clause.parameters(functionNameClause, columnNameClause));
        }
    }
}

