/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.cdm.example.util;

import com.google.common.io.Resources;
import com.regnosys.rosetta.common.hashing.ReferenceResolverProcessStep;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapper;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.isda.cdm.processor.CdmReferenceConfig;

public class ResourcesUtils {
    public static String getJson(String resourceName) throws IOException {
        URL url = Resources.getResource((String)resourceName);
        String json = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        return json;
    }

    public static <T extends RosettaModelObject> T getObject(Class<T> clazz, String resourceName) throws IOException {
        String json = ResourcesUtils.getJson(resourceName);
        return (T)((RosettaModelObject)RosettaObjectMapper.getNewRosettaObjectMapper().readValue(json, clazz));
    }

    public static <T extends RosettaModelObject> T getObjectAndResolveReferences(Class<T> clazz, String resourceName) throws IOException {
        T object = ResourcesUtils.getObject(clazz, resourceName);
        return ResourcesUtils.resolveReferences(object);
    }

    private static <T extends RosettaModelObject> T resolveReferences(T object) {
        RosettaModelObjectBuilder builder = object.toBuilder();
        new ReferenceResolverProcessStep(CdmReferenceConfig.get()).runProcessStep(builder.getType(), (RosettaModelObject)builder);
        return (T)builder.build();
    }
}

