/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.cdm.example.qualify;

import cdm.event.common.TradeState;
import com.google.common.io.Resources;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationReport;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationResult;
import com.regnosys.rosetta.common.postprocess.qualify.QualifyProcessorStep;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapper;
import com.rosetta.model.lib.RosettaModelObject;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.finos.cdm.CdmRuntimeModule;

public class QualificationReportExample {
    public static void main(String[] args) throws IOException {
        URL resource = Resources.getResource((String)"result-json-files/fpml-5-10/products/rates/bond-option-uti.json");
        TradeState tradeState = (TradeState)RosettaObjectMapper.getNewRosettaObjectMapper().readValue(resource, TradeState.class);
        Injector injector = Guice.createInjector((Module[])new Module[]{new CdmRuntimeModule()});
        QualifyProcessorStep qualifyProcessorStep = (QualifyProcessorStep)injector.getInstance(QualifyProcessorStep.class);
        QualificationReport qualificationReport = qualifyProcessorStep.runProcessStep(tradeState.getType(), (RosettaModelObject)tradeState.toBuilder());
        int qualifiableObjectsCount = qualificationReport.getUniquelyQualifiedObjectsCount();
        System.out.println("The number of unique qualifications was " + qualifiableObjectsCount);
        qualificationReport.getResults().stream().map(QualificationResult::getAllQualifyResults).flatMap(Collection::stream).sorted((c, o) -> Boolean.compare(o.isSuccess(), c.isSuccess())).forEach(x -> System.out.println(String.format("Qualification %s: %-50s - %s", x.isSuccess() ? "PASS" : "FAIL", x.getName(), x.getExpressionDataRuleResults())));
    }
}

