/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.cdm.example.globalkey;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapper;
import com.rosetta.lib.postprocess.PostProcessorReport;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.PostProcessStep;
import com.rosetta.model.lib.process.ProcessingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class SerialisingHashFunction
implements PostProcessStep {
    public Integer getPriority() {
        return Integer.MAX_VALUE;
    }

    public String getName() {
        return "SHA-256 key calculator";
    }

    public String hash(RosettaModelObject object) {
        return this.computeHashes(object.getClass(), object);
    }

    private <T extends RosettaModelObject> String computeHashes(Class<? extends T> clazz, T object) {
        PostProcessorReport report = this.runProcessStep((Class)clazz, (RosettaModelObject)object);
        return report.getResultHash();
    }

    public <T extends RosettaModelObject> StringHashPostProcessReport runProcessStep(Class<? extends T> topClass, T instance) {
        RosettaModelObject built = instance.build();
        try {
            byte[] bytes = RosettaObjectMapper.getNewRosettaObjectMapper().writeValueAsBytes((Object)built);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return new StringHashPostProcessReport(Base64.getEncoder().encodeToString(digest.digest(bytes)), instance);
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            throw new ProcessingException("Unable to generate hash for object: " + built.toString(), built.getClass().getSimpleName(), this.getName(), RosettaPath.valueOf((String)""), e);
        }
    }

    class StringHashPostProcessReport
    implements PostProcessorReport {
        private final String resultHash;
        private final RosettaModelObject resultObject;

        public String getResultHash() {
            return this.resultHash;
        }

        public StringHashPostProcessReport(String resultHash, RosettaModelObject resultObject) {
            this.resultHash = resultHash;
            this.resultObject = resultObject;
        }

        public RosettaModelObject getResultObject() {
            return this.resultObject;
        }
    }
}

