/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.cdm.example.functions;

import cdm.base.math.NonNegativeQuantity;
import cdm.product.asset.functions.FixedAmount;
import cdm.product.asset.functions.FloatingAmount;
import com.google.inject.Inject;
import com.regnosys.cdm.example.AbstractExample;
import com.regnosys.cdm.example.InterestRatePayoutCreation;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.BigDecimalCloseTo;

public class InterestRateCalculationExample
extends AbstractExample {
    private static final Date REFERENCE_DATE = Date.of((int)2018, (int)8, (int)22);
    @Inject
    FixedAmount fixedAmount;
    @Inject
    FloatingAmount floatingAmount;

    @Override
    public void example() {
        NonNegativeQuantity notional = NonNegativeQuantity.builder().setValue(BigDecimal.valueOf(50000000L)).build();
        BigDecimal fixedRate = BigDecimal.valueOf(0.06);
        BigDecimal rate = BigDecimal.valueOf(0.0875);
        BigDecimal fixedAmountResult = this.fixedAmount.evaluate(InterestRatePayoutCreation.getFixedRatePayout(fixedRate), notional.getValue(), REFERENCE_DATE, null);
        BigDecimal floatingAmountResult = this.floatingAmount.evaluate(InterestRatePayoutCreation.getFloatingRatePayout(), rate, notional.getValue(), REFERENCE_DATE, null);
        System.out.println(fixedAmountResult);
        MatcherAssert.assertThat((String)"Computed fixed amount matches expectation", (Object)fixedAmountResult, (Matcher)BigDecimalCloseTo.closeTo((BigDecimal)new BigDecimal("750000.0000"), (BigDecimal)new BigDecimal("0.005")));
        System.out.println(floatingAmountResult);
        MatcherAssert.assertThat((String)"Computed floating amount matches expectation", (Object)floatingAmountResult, (Matcher)BigDecimalCloseTo.closeTo((BigDecimal)new BigDecimal("2205479.45"), (BigDecimal)new BigDecimal("0.005")));
    }

    public static void main(String[] args) {
        new InterestRateCalculationExample().run();
    }
}

