/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.cdm.example.functions;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.datetime.daycount.metafields.FieldWithMetaDayCountFractionEnum;
import cdm.base.math.NonNegativeQuantity;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.functions.FloatingAmount;
import com.google.inject.Inject;
import com.regnosys.cdm.example.AbstractExample;
import com.regnosys.cdm.example.InterestRatePayoutCreation;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.BigDecimalCloseTo;

public class FloatingRateCalculationWithFunction
extends AbstractExample {
    @Inject
    private FloatingAmount floatingAmount;

    @Override
    public void example() {
        LocalDate floatingLegPeriodStart = LocalDate.of(2018, 7, 3);
        BigDecimal notional = BigDecimal.valueOf(50000000L);
        BigDecimal rate = BigDecimal.valueOf(0.0875);
        FieldWithMetaDayCountFractionEnum floatingLegDCF = FieldWithMetaDayCountFractionEnum.builder().setValue(DayCountFractionEnum.ACT_365_FIXED).build();
        NonNegativeQuantity quantity = NonNegativeQuantity.builder().setValue(notional).build();
        InterestRatePayout floatingRatePayout = InterestRatePayoutCreation.getFloatingRatePayout().toBuilder().setDayCountFraction(floatingLegDCF).build();
        BigDecimal floatingAmountResult = this.floatingAmount.evaluate(floatingRatePayout, rate, quantity.getValue(), Date.of((LocalDate)floatingLegPeriodStart), null);
        System.out.println(floatingAmountResult);
        MatcherAssert.assertThat((String)"Computed floating amount matches expectation", (Object)floatingAmountResult, (Matcher)BigDecimalCloseTo.closeTo((BigDecimal)new BigDecimal("2205479.45"), (BigDecimal)new BigDecimal("0.005")));
    }

    public static void main(String[] args) {
        new FloatingRateCalculationWithFunction().run();
    }
}

