/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.cdm.example.functions;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.datetime.daycount.metafields.FieldWithMetaDayCountFractionEnum;
import cdm.base.math.NonNegativeQuantity;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.functions.FixedAmount;
import com.google.inject.Inject;
import com.regnosys.cdm.example.AbstractExample;
import com.regnosys.cdm.example.InterestRatePayoutCreation;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.BigDecimalCloseTo;

public class FixedRateCalculationWithFunction
extends AbstractExample {
    @Inject
    private FixedAmount fixedAmount;

    @Override
    public void example() {
        LocalDate fixedLegPeriodStart = LocalDate.of(2018, 7, 3);
        FieldWithMetaDayCountFractionEnum fixedLegDCF = FieldWithMetaDayCountFractionEnum.builder().setValue(DayCountFractionEnum._30E_360).build();
        BigDecimal fixedRate = BigDecimal.valueOf(0.06);
        NonNegativeQuantity notional = NonNegativeQuantity.builder().setValue(BigDecimal.valueOf(50000000L)).build();
        InterestRatePayout fixedRatePayout = InterestRatePayoutCreation.getFixedRatePayout(fixedRate).toBuilder().setDayCountFraction(fixedLegDCF).build();
        BigDecimal fixedAmountResult = this.fixedAmount.evaluate(fixedRatePayout, notional.getValue(), Date.of((LocalDate)fixedLegPeriodStart), null);
        MatcherAssert.assertThat((String)"Computed fixed amount matches expectation", (Object)fixedAmountResult, (Matcher)BigDecimalCloseTo.closeTo((BigDecimal)new BigDecimal("750000.0000"), (BigDecimal)new BigDecimal("0.005")));
    }

    public static void main(String[] args) {
        new FixedRateCalculationWithFunction().run();
    }
}

