/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.cdm.example;

import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.meta.InterestRatePayoutMeta;
import cdm.product.template.Payout;
import cdm.product.template.validation.datarule.PayoutDayCountFraction;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.regnosys.cdm.example.AbstractExample;
import com.regnosys.cdm.example.InterestRatePayoutCreation;
import com.regnosys.rosetta.common.validation.RosettaTypeValidator;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import javax.inject.Inject;

public class Validation
extends AbstractExample {
    @Inject
    private ValidatorFactory.Default validatorFactory;
    @Inject
    private RosettaTypeValidator validator;
    @Inject
    private PayoutDayCountFraction condition;

    @Override
    public void example() {
        InterestRatePayout fixedRatePayout = InterestRatePayoutCreation.getFixedRatePayout(BigDecimal.valueOf(0.05));
        this.validator.runProcessStep(InterestRatePayout.class, (RosettaModelObject)fixedRatePayout.toBuilder()).getValidationResults().forEach(System.out::println);
        InterestRatePayoutMeta fixedRatePayoutMeta = (InterestRatePayoutMeta)fixedRatePayout.metaData();
        ArrayList validators = Lists.newArrayList((Iterable)Iterables.concat((Iterable)fixedRatePayoutMeta.choiceRuleValidators(), (Iterable)fixedRatePayoutMeta.dataRules((ValidatorFactory)this.validatorFactory)));
        validators.add(fixedRatePayoutMeta.validator());
        validators.stream().map(validator -> validator.validate(RosettaPath.valueOf((String)"InterestRatePayout"), (RosettaModelObject)fixedRatePayout)).sorted(Comparator.comparing(ValidationResult::isSuccess, Boolean::compareTo)).forEach(System.out::println);
        ValidationResult validationResult = this.condition.validate(RosettaPath.valueOf((String)"InterestRatePayout"), Payout.builder().addInterestRatePayout(fixedRatePayout).build());
        System.out.println("\nSingle validation result:\n" + validationResult);
    }

    public static void main(String[] args) {
        new Validation().run();
    }
}

