/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.cdm.example;

import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.meta.EconomicTermsMeta;
import com.google.inject.Inject;
import com.regnosys.cdm.example.AbstractExample;
import com.regnosys.cdm.example.InterestRatePayoutCreation;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationHandlerProvider;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.qualify.QualifyResultsExtractor;
import java.math.BigDecimal;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.isda.cdm.qualify.EconomicTermsQualificationHandler;

public class Qualification
extends AbstractExample {
    @Inject
    private QualifyFunctionFactory.Default qualifyFunctionFactory;
    @Inject
    private QualificationHandlerProvider qualificationHandlerProvider;

    @Override
    public void example() {
        ContractualProduct contractualProduct = ContractualProduct.builder().setEconomicTerms((EconomicTerms)EconomicTerms.builder().setPayout((Payout)Payout.builder().addInterestRatePayout(InterestRatePayoutCreation.getFixedRatePayout(BigDecimal.valueOf(0.05))).addInterestRatePayout(InterestRatePayoutCreation.getFloatingRatePayout()))).build();
        List qualifyFunctions = new EconomicTermsMeta().getQualifyFunctions((QualifyFunctionFactory)this.qualifyFunctionFactory);
        String qualificationResult = new QualifyResultsExtractor(qualifyFunctions, (RosettaModelObject)contractualProduct.getEconomicTerms()).getOnlySuccessResult().map(QualifyResult::getName).orElse("Failed to qualify");
        System.out.println(qualificationResult);
        MatcherAssert.assertThat((Object)qualificationResult, (Matcher)CoreMatchers.is((Object)"InterestRate_IRSwap_FixedFloat"));
        EconomicTermsQualificationHandler qualificationHandler = new EconomicTermsQualificationHandler();
        ContractualProduct.ContractualProductBuilder contractualProductBuilder = contractualProduct.toBuilder();
        qualificationHandler.setQualifier(contractualProductBuilder, qualificationResult);
        MatcherAssert.assertThat((Object)qualificationHandler.getQualifier((ContractualProduct)contractualProductBuilder), (Matcher)CoreMatchers.is((Object)"InterestRate_IRSwap_FixedFloat"));
    }

    public static void main(String[] args) {
        new Qualification().run();
    }
}

