/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.cdm.example;

import cdm.base.datetime.AdjustableDates;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyIdentifier;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Trade;
import cdm.event.common.TradeIdentifier;
import cdm.observable.asset.Observable;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceExpression;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.QuoteBasisEnum;
import cdm.observable.asset.QuotedCurrencyPair;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.asset.ForeignExchange;
import cdm.product.common.settlement.Cashflow;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementDate;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.regnosys.rosetta.common.hashing.GlobalKeyProcessStep;
import com.regnosys.rosetta.common.hashing.NonNullHashCollector;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapper;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.Key;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.process.PostProcessStep;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.List;

public class FxSwapContractCreation {
    private final PostProcessStep keyProcessor = new GlobalKeyProcessStep(NonNullHashCollector::new);

    public static void main(String[] args) throws JsonProcessingException {
        FxSwapContractCreation fxSwapContractCreation = new FxSwapContractCreation();
        Trade fxSwapContract = fxSwapContractCreation.createFxSwapContractExample();
        String json = RosettaObjectMapper.getNewRosettaObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)fxSwapContract);
        System.out.println(json);
    }

    private Trade createFxSwapContractExample() {
        String currency1Str = "GBP";
        long quantity1 = 10000000L;
        String currency2Str = "USD";
        long quantity2 = 14800000L;
        double rate = 1.48;
        Party party1 = this.addGlobalKey(Party.class, this.createParty("5493000SCC07UI6DB380", "http://www.fpml.org/coding-scheme/external/iso17442"));
        Party party2 = this.addGlobalKey(Party.class, this.createParty("529900DTJ5A7S5UCBB52", "http://www.fpml.org/coding-scheme/external/iso17442"));
        PriceQuantity priceQuantity = this.createPriceQuantity(currency1Str, quantity1, currency2Str, quantity2, rate);
        Product underlier = this.createForeignExchangeUnderlier(this.createExchangeCurrency(CounterpartyRoleEnum.PARTY_1, CounterpartyRoleEnum.PARTY_2), this.createExchangeCurrency(CounterpartyRoleEnum.PARTY_2, CounterpartyRoleEnum.PARTY_1));
        Date settlementDate = Date.of((int)2001, (int)10, (int)25);
        Date tradeDate = Date.of((int)2001, (int)10, (int)23);
        ContractualProduct contractualProduct = this.createContractualProduct(underlier, settlementDate);
        TradeIdentifier citi123 = this.createIdentifier("CITI123", "http://www.citi.com/fx/trade-id", party1);
        TradeIdentifier barc987 = this.createIdentifier("BARC987", "http://www.barclays.com/fx/trade-id", party2);
        List<TradeIdentifier> identifiers = List.of(citi123, barc987);
        List<Party> parties = List.of(party1, party2);
        return this.createFxSwapContract(identifiers, parties, priceQuantity, contractualProduct, tradeDate, party1, party2);
    }

    private PriceQuantity createPriceQuantity(String currency1Str, long quantity1, String currency2Str, long quantity2, double rate) {
        return PriceQuantity.builder().addPrice((FieldWithMetaPriceSchedule)FieldWithMetaPriceSchedule.builder().setMeta((MetaFields)MetaFields.builder().addKey((Key)Key.builder().setScope("DOCUMENT").setKeyValue("price-1"))).setValue((PriceSchedule)Price.builder().setValue(BigDecimal.valueOf(rate)).setUnit((UnitType)UnitType.builder().setCurrencyValue(currency1Str)).setPerUnitOf((UnitType)UnitType.builder().setCurrencyValue(currency2Str)).setPriceExpression((PriceExpression)PriceExpression.builder().setPriceType(PriceTypeEnum.EXCHANGE_RATE)))).addQuantity((FieldWithMetaNonNegativeQuantitySchedule)FieldWithMetaNonNegativeQuantitySchedule.builder().setMeta((MetaFields)MetaFields.builder().addKey((Key)Key.builder().setScope("DOCUMENT").setKeyValue("quantity-1"))).setValue((NonNegativeQuantitySchedule)NonNegativeQuantitySchedule.builder().setValue(BigDecimal.valueOf(quantity1)).setUnit((UnitType)UnitType.builder().setCurrencyValue(currency1Str)))).addQuantity((FieldWithMetaNonNegativeQuantitySchedule)FieldWithMetaNonNegativeQuantitySchedule.builder().setMeta((MetaFields)MetaFields.builder().addKey((Key)Key.builder().setScope("DOCUMENT").setKeyValue("quantity-2"))).setValue((NonNegativeQuantitySchedule)NonNegativeQuantitySchedule.builder().setValue(BigDecimal.valueOf(quantity2)).setUnit((UnitType)UnitType.builder().setCurrencyValue(currency2Str)))).setObservable((Observable)Observable.builder().setCurrencyPairValue((QuotedCurrencyPair)QuotedCurrencyPair.builder().setCurrency1Value(currency1Str).setCurrency2Value(currency2Str).setQuoteBasis(QuoteBasisEnum.CURRENCY_2_PER_CURRENCY_1))).build();
    }

    private Trade createFxSwapContract(List<TradeIdentifier> identifiers, List<Party> parties, PriceQuantity priceQuantity, ContractualProduct contractualProduct, Date tradeDate, Party party1, Party party2) {
        Trade trade = Trade.builder().addTradeIdentifier(identifiers).setTradableProduct((TradableProduct)TradableProduct.builder().addCounterparty((Counterparty)Counterparty.builder().setPartyReferenceValue(party1).setRole(CounterpartyRoleEnum.PARTY_1)).addCounterparty((Counterparty)Counterparty.builder().setPartyReferenceValue(party2).setRole(CounterpartyRoleEnum.PARTY_2)).addTradeLot((TradeLot)TradeLot.builder().addPriceQuantity(priceQuantity)).setProduct((Product)Product.builder().setContractualProduct(contractualProduct))).addParty(parties).setTradeDate(FieldWithMetaDate.builder().setValue(tradeDate).build()).build();
        return this.addGlobalKey(Trade.class, trade);
    }

    private Product createForeignExchangeUnderlier(Cashflow exchangedCurrency1, Cashflow exchangedCurrency2) {
        return Product.builder().setForeignExchange(ForeignExchange.builder().setExchangedCurrency1(exchangedCurrency1).setExchangedCurrency2(exchangedCurrency2).build()).build();
    }

    private Cashflow createExchangeCurrency(CounterpartyRoleEnum payer, CounterpartyRoleEnum receiver) {
        return Cashflow.builder().setPriceQuantity((ResolvablePriceQuantity)ResolvablePriceQuantity.builder().setQuantitySchedule((ReferenceWithMetaNonNegativeQuantitySchedule)ReferenceWithMetaNonNegativeQuantitySchedule.builder().setReference((Reference)Reference.builder().setScope("DOCUMENT").setReference("quantity-2")))).setPayerReceiver((PayerReceiver)PayerReceiver.builder().setPayer(payer).setReceiver(receiver)).build();
    }

    private ContractualProduct createContractualProduct(Product underlier, Date settlementDate) {
        return ContractualProduct.builder().setEconomicTerms(EconomicTerms.builder().setPayout((Payout)Payout.builder().addForwardPayout((ForwardPayout)ForwardPayout.builder().setSettlementTerms((SettlementTerms)SettlementTerms.builder().setSettlementDate((SettlementDate)SettlementDate.builder().setAdjustableDates((AdjustableDates)AdjustableDates.builder().addAdjustedDateValue(settlementDate)))).setUnderlier(underlier))).build());
    }

    private Party createParty(String partyId, String scheme) {
        return Party.builder().addPartyId(PartyIdentifier.builder().setIdentifierValue(partyId).setMeta(MetaFields.builder().setScheme(scheme).build()).build()).build();
    }

    private TradeIdentifier createIdentifier(String identifier, String scheme, Party issuer) {
        return TradeIdentifier.builder().addAssignedIdentifier(AssignedIdentifier.builder().setIdentifier(FieldWithMetaString.builder().setValue(identifier).setMeta(MetaFields.builder().setScheme(scheme).build()).build()).build()).setIssuerReference(ReferenceWithMetaParty.builder().setGlobalReference(this.getGlobalReference((GlobalKey)issuer)).build()).build();
    }

    private <T extends RosettaModelObject> T addGlobalKey(Class<T> type, T modelObject) {
        RosettaModelObjectBuilder builder = modelObject.toBuilder();
        this.keyProcessor.runProcessStep(type, (RosettaModelObject)builder);
        return (T)((RosettaModelObject)type.cast(builder.build()));
    }

    private String getGlobalReference(GlobalKey globalKey) {
        return globalKey.getMeta().getGlobalKey();
    }
}

