/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.cdm.example;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.regnosys.cdm.example.AbstractExample;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapper;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumSerialisation
extends AbstractExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumSerialisation.class);

    @Override
    public void example() throws RuntimeException {
        ObjectMapper rosettaObjectMapper = RosettaObjectMapper.getNewRosettaObjectMapper();
        LOGGER.info("Example of enum without a displayName");
        EnumSerialisation.checkSerialisation(rosettaObjectMapper, DayCountFractionEnum.ACT_360);
        LOGGER.info("-------------------------------------------------");
        LOGGER.info("Example of enum with a displayName");
        EnumSerialisation.checkSerialisation(rosettaObjectMapper, DayCountFractionEnum.ACT_365L);
    }

    private static void checkSerialisation(ObjectMapper rosettaObjectMapper, DayCountFractionEnum myEnum) {
        try {
            String json = rosettaObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)myEnum);
            LOGGER.info("Enum: " + myEnum.name());
            LOGGER.info("Serialise to JSON: " + json);
            DayCountFractionEnum deserializedObject = (DayCountFractionEnum)rosettaObjectMapper.readValue(json, myEnum.getClass());
            LOGGER.info("Deserialised Enum: " + deserializedObject.name());
            MatcherAssert.assertThat((String)"The enum and serialized-then-deserialized objects are the same", (Object)myEnum, (Matcher)IsEqual.equalTo((Object)deserializedObject));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        new EnumSerialisation().run();
    }
}

