/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.redis.RedisConnection;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.PropertyJsonParser;
import redis.clients.jedis.Jedis;

public class PropertyStoreRedis
extends AbstractPropertyStore {
    private RedisConnection redisConnection;

    public PropertyStoreRedis() {
        this(new RedisConnection());
    }

    public PropertyStoreRedis(RedisConnection pRedisConnection) {
        this.redisConnection = pRedisConnection;
    }

    public PropertyStoreRedis(String xmlFeaturesfFile) {
        this();
        this.importPropertiesFromXmlFile(xmlFeaturesfFile);
    }

    public PropertyStoreRedis(String host, int port) {
        this(new RedisConnection(host, port));
    }

    public PropertyStoreRedis(String host, int port, String password, String xmlFeaturesfFile) {
        this(new RedisConnection(host, port, password));
        this.importPropertiesFromXmlFile(xmlFeaturesfFile);
    }

    public PropertyStoreRedis(String host, int port, String xmlFeaturesfFile) {
        this(host, port);
        this.importPropertiesFromXmlFile(xmlFeaturesfFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existProperty(String name) {
        Util.assertParamHasLength((String)name, (String)"PropertyName identifier");
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            boolean bl = jedis.exists("FF4J_PROPERTY_" + name);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void createProperty(Property<T> prop) {
        Util.assertNotNull((Object[])new Object[]{prop});
        if (this.existProperty(prop.getName())) {
            throw new PropertyAlreadyExistException(prop.getName());
        }
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            String name = prop.getName();
            jedis.sadd("FF4J_PROPERTY_MAP", new String[]{name});
            jedis.set("FF4J_PROPERTY_" + name, prop.toJson());
            jedis.persist("FF4J_PROPERTY_" + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property<?> readProperty(String name) {
        this.assertPropertyExist(name);
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Property property = PropertyJsonParser.parseProperty((String)jedis.get("FF4J_PROPERTY_" + name));
            return property;
        }
    }

    public void deleteProperty(String name) {
        this.assertPropertyExist(name);
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            jedis.srem("FF4J_PROPERTY_MAP", new String[]{name});
            jedis.del("FF4J_PROPERTY_" + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Property<?>> readAllProperties() {
        LinkedHashMap mapP = new LinkedHashMap();
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Set properties = jedis.smembers("FF4J_PROPERTY_MAP");
            if (properties != null) {
                for (String key : properties) {
                    mapP.put(key, this.readProperty(key));
                }
            }
            LinkedHashMap<String, Property<?>> linkedHashMap = mapP;
            return linkedHashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> listPropertyNames() {
        try (Jedis jedis = null;){
            Set propertyNames;
            jedis = this.getJedis();
            Set set = propertyNames = jedis.smembers("FF4J_PROPERTY_MAP");
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Set myKeys = jedis.smembers("FF4J_PROPERTY_MAP");
            for (String key : myKeys) {
                this.deleteProperty(key);
            }
        }
    }

    public RedisConnection getRedisConnection() {
        return this.redisConnection;
    }

    public void setRedisConnection(RedisConnection redisConnection) {
        this.redisConnection = redisConnection;
    }

    public Jedis getJedis() {
        if (this.redisConnection == null) {
            throw new IllegalArgumentException("Cannot found any redisConnection");
        }
        Jedis jedis = this.redisConnection.getJedis();
        if (jedis == null) {
            throw new IllegalArgumentException("Cannot found any jedis connection, please build connection");
        }
        return jedis;
    }
}

