/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.Period;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsFirstDayOfMonth;
import org.exparity.hamcrest.date.core.IsLastDayOfMonth;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.TemporalConverters;
import org.exparity.hamcrest.date.core.TemporalFunctions;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.exparity.hamcrest.date.core.TemporalProviders;
import org.exparity.hamcrest.date.core.types.Interval;

public abstract class LocalDateMatchers {
    public static TemporalMatcher<LocalDate> after(LocalDate date) {
        return new IsAfter<LocalDate, LocalDate>(TemporalConverters.LOCALDATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    public static TemporalMatcher<LocalDate> after(int year, Month month, int dayOfMonth) {
        return LocalDateMatchers.after(LocalDate.of(year, month, dayOfMonth));
    }

    public static TemporalMatcher<LocalDate> before(LocalDate date) {
        return new IsBefore<LocalDate, LocalDate>(TemporalConverters.LOCALDATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    public static TemporalMatcher<LocalDate> before(int year, Month month, int dayOfMonth) {
        return LocalDateMatchers.before(LocalDate.of(year, month, dayOfMonth));
    }

    public static TemporalMatcher<LocalDate> sameDay(LocalDate date) {
        return new IsSameDay<LocalDate>(TemporalConverters.LOCALDATE_AS_LOCALDATE, TemporalProviders.localDate(date));
    }

    public static TemporalMatcher<LocalDate> isDay(int year, Month month, int dayOfMonth) {
        return LocalDateMatchers.sameDay(LocalDate.of(year, month, dayOfMonth));
    }

    public static TemporalMatcher<LocalDate> sameOrBefore(LocalDate date) {
        return new IsSameOrBefore<LocalDate, LocalDate>(TemporalConverters.LOCALDATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    public static TemporalMatcher<LocalDate> sameOrBefore(int year, Month month, int day) {
        return LocalDateMatchers.sameOrBefore(LocalDate.of(year, month, day));
    }

    public static TemporalMatcher<LocalDate> sameOrAfter(LocalDate date) {
        return new IsSameOrAfter<LocalDate, LocalDate>(TemporalConverters.LOCALDATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    public static TemporalMatcher<LocalDate> sameOrAfter(int year, Month month, int day) {
        return LocalDateMatchers.sameOrAfter(LocalDate.of(year, month, day));
    }

    public static TemporalMatcher<LocalDate> sameMonthOfYear(LocalDate date) {
        return LocalDateMatchers.isMonth(date.getMonth());
    }

    public static TemporalMatcher<LocalDate> sameDayOfMonth(LocalDate date) {
        return new IsDayOfMonth<LocalDate>(TemporalConverters.LOCALDATE_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(date));
    }

    public static TemporalMatcher<LocalDate> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<LocalDate>(TemporalConverters.LOCALDATE_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(dayOfMonth));
    }

    public static TemporalMatcher<LocalDate> sameYear(LocalDate date) {
        return new IsYear<LocalDate>(TemporalConverters.LOCALDATE_AS_YEAR, TemporalProviders.year(date));
    }

    public static TemporalMatcher<LocalDate> isYear(int year) {
        return new IsYear<LocalDate>(TemporalConverters.LOCALDATE_AS_YEAR, TemporalProviders.year(year));
    }

    public static TemporalMatcher<LocalDate> within(Period period, LocalDate date) {
        return new IsWithin<LocalDate, LocalDate>(Interval.of(period), TemporalConverters.LOCALDATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    public static TemporalMatcher<LocalDate> within(long period, ChronoUnit unit, LocalDate date) {
        return new IsWithin<LocalDate, LocalDate>(Interval.of(period, unit), TemporalConverters.LOCALDATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    public static TemporalMatcher<LocalDate> within(long period, ChronoUnit unit, int year, Month month, int dayofMonth) {
        return LocalDateMatchers.within(period, unit, LocalDate.of(year, month, dayofMonth));
    }

    public static TemporalMatcher<LocalDate> isYesterday() {
        return LocalDateMatchers.sameDay(LocalDate.now().plusDays(-1L));
    }

    public static TemporalMatcher<LocalDate> isToday() {
        return LocalDateMatchers.sameDay(LocalDate.now());
    }

    public static TemporalMatcher<LocalDate> isTomorrow() {
        return LocalDateMatchers.sameDay(LocalDate.now().plusDays(1L));
    }

    public static TemporalMatcher<LocalDate> sameDayOfWeek(LocalDate date) {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.from(date));
    }

    public static TemporalMatcher<LocalDate> isDayOfWeek(DayOfWeek dayOfWeek) {
        return new IsDayOfWeek<LocalDate>(TemporalConverters.LOCALDATE_AS_DAYOFWEEK, TemporalProviders.daysOfWeek(dayOfWeek));
    }

    public static TemporalMatcher<LocalDate> isDayOfWeek(DayOfWeek ... daysOfWeek) {
        return new IsDayOfWeek<LocalDate>(TemporalConverters.LOCALDATE_AS_DAYOFWEEK, TemporalProviders.daysOfWeek(daysOfWeek));
    }

    public static TemporalMatcher<LocalDate> isMonday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.MONDAY);
    }

    public static TemporalMatcher<LocalDate> isTuesday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.TUESDAY);
    }

    public static TemporalMatcher<LocalDate> isWednesday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.WEDNESDAY);
    }

    public static TemporalMatcher<LocalDate> isThursday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.THURSDAY);
    }

    public static TemporalMatcher<LocalDate> isFriday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.FRIDAY);
    }

    public static TemporalMatcher<LocalDate> isSaturday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.SATURDAY);
    }

    public static TemporalMatcher<LocalDate> isSunday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.SUNDAY);
    }

    public static TemporalMatcher<LocalDate> isWeekday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static TemporalMatcher<LocalDate> isWeekend() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static TemporalMatcher<LocalDate> isFirstDayOfMonth() {
        return new IsFirstDayOfMonth<LocalDate>(TemporalConverters.LOCALDATE_AS_LOCALDATE);
    }

    public static TemporalMatcher<LocalDate> isMinimum(ChronoField field) {
        return new IsMinimum<LocalDate>(TemporalConverters.LOCALDATE_AS_LOCALDATE, field);
    }

    public static TemporalMatcher<LocalDate> isLastDayOfMonth() {
        return new IsLastDayOfMonth<LocalDate>(TemporalConverters.LOCALDATE_AS_LOCALDATE);
    }

    public static TemporalMatcher<LocalDate> isMaximum(ChronoField field) {
        return new IsMaximum<LocalDate>(TemporalConverters.LOCALDATE_AS_LOCALDATE, field);
    }

    public static TemporalMatcher<LocalDate> isMonth(Month month) {
        return new IsMonth<LocalDate>(TemporalConverters.LOCALDATE_AS_MONTH, TemporalProviders.month(month));
    }

    public static TemporalMatcher<LocalDate> isJanuary() {
        return LocalDateMatchers.isMonth(Month.JANUARY);
    }

    public static TemporalMatcher<LocalDate> isFebruary() {
        return LocalDateMatchers.isMonth(Month.FEBRUARY);
    }

    public static TemporalMatcher<LocalDate> isMarch() {
        return LocalDateMatchers.isMonth(Month.MARCH);
    }

    public static TemporalMatcher<LocalDate> isApril() {
        return LocalDateMatchers.isMonth(Month.APRIL);
    }

    public static TemporalMatcher<LocalDate> isMay() {
        return LocalDateMatchers.isMonth(Month.MAY);
    }

    public static TemporalMatcher<LocalDate> isJune() {
        return LocalDateMatchers.isMonth(Month.JUNE);
    }

    public static TemporalMatcher<LocalDate> isJuly() {
        return LocalDateMatchers.isMonth(Month.JULY);
    }

    public static TemporalMatcher<LocalDate> isAugust() {
        return LocalDateMatchers.isMonth(Month.AUGUST);
    }

    public static TemporalMatcher<LocalDate> isSeptember() {
        return LocalDateMatchers.isMonth(Month.SEPTEMBER);
    }

    public static TemporalMatcher<LocalDate> isOctober() {
        return LocalDateMatchers.isMonth(Month.OCTOBER);
    }

    public static TemporalMatcher<LocalDate> isNovember() {
        return LocalDateMatchers.isMonth(Month.NOVEMBER);
    }

    public static TemporalMatcher<LocalDate> isDecember() {
        return LocalDateMatchers.isMonth(Month.DECEMBER);
    }

    public static TemporalMatcher<LocalDate> isLeapYear() {
        return new IsLeapYear<LocalDate>(TemporalConverters.LOCALDATE_AS_YEAR);
    }
}

