/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.beans.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.exparity.beans.core.BeanPropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodWrapper {
    private final Method method;

    MethodWrapper(Method method) {
        this.method = method;
    }

    Class<?>[] genericArgs() {
        Type type = this.method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            ArrayList<Class> params = new ArrayList<Class>();
            for (Type arg : ((ParameterizedType)type).getActualTypeArguments()) {
                if (!(arg instanceof Class)) continue;
                params.add((Class)arg);
            }
            return params.toArray(new Class[0]);
        }
        return new Class[0];
    }

    Object invoke(Object instance) {
        try {
            return this.method.invoke(instance, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new BeanPropertyException("Method '" + this.method.getName() + "' does not exist on '" + instance.getClass() + "'");
        }
        catch (IllegalAccessException e) {
            throw new BeanPropertyException("Illegal Access exception encountered whilst calling '" + this.method.getName() + " on '" + instance.getClass().getCanonicalName() + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new BeanPropertyException("Unexpected exception whilst calling '" + this.method.getName() + " on '" + instance.getClass().getCanonicalName() + "'", e.getCause());
        }
    }

    boolean invoke(Object instance, Object value) {
        try {
            this.method.invoke(instance, value);
        }
        catch (IllegalArgumentException e) {
            throw new BeanPropertyException("Method '" + this.method.getName() + " on '" + instance.getClass().getCanonicalName() + "' expected arguments '" + StringUtils.join((Object[])this.method.getParameterTypes()) + "'  but was supplied a '" + value.getClass().getSimpleName(), e);
        }
        catch (IllegalAccessException e) {
            throw new BeanPropertyException("Illegal Access exception encountered whilst calling '" + this.method.getName() + " on '" + instance.getClass().getCanonicalName() + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new BeanPropertyException("Unexpected exception whilst calling '" + this.method.getName() + " on '" + instance.getClass().getCanonicalName() + "'", e.getTargetException());
        }
        return true;
    }

    Class<?> getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    Method getMethod() {
        return this.method;
    }

    Class<?> getReturnType() {
        return this.method.getReturnType();
    }
}

