/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.beans.core;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exparity.beans.BeanPredicates;
import org.exparity.beans.core.BeanNamingStrategy;
import org.exparity.beans.core.BeanProperty;
import org.exparity.beans.core.BeanPropertyFunction;
import org.exparity.beans.core.BeanPropertyNotFoundException;
import org.exparity.beans.core.BeanPropertyPredicate;
import org.exparity.beans.core.BeanVisitor;
import org.exparity.beans.core.InstanceInspector;
import org.exparity.beans.core.functions.SetValue;
import org.exparity.beans.core.visitors.ApplyFunctionIf;
import org.exparity.beans.core.visitors.CapturePropertyIf;
import org.exparity.beans.core.visitors.CapturePropertyToList;
import org.exparity.beans.core.visitors.CapturePropertyToListIf;
import org.exparity.beans.core.visitors.CapturePropertyToMap;
import org.exparity.beans.core.visitors.Print;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Instance {
    private final InstanceInspector inspector;
    private final Object instance;
    private BeanNamingStrategy naming;

    protected Instance(InstanceInspector inspector, Object instance, BeanNamingStrategy naming) {
        this.inspector = inspector;
        this.instance = instance;
        this.naming = naming;
    }

    public List<BeanProperty> propertyList() {
        ArrayList<BeanProperty> propertyList = new ArrayList<BeanProperty>();
        this.visit(new CapturePropertyToList(propertyList));
        return propertyList;
    }

    public Map<String, BeanProperty> propertyMap() {
        HashMap<String, BeanProperty> propertyMap = new HashMap<String, BeanProperty>();
        this.visit(new CapturePropertyToMap(propertyMap));
        return propertyMap;
    }

    public void setProperty(BeanPropertyPredicate predicate, Object value) {
        this.apply(new SetValue(value), predicate);
    }

    public Object propertyValue(BeanPropertyPredicate predicate) {
        BeanProperty property = this.findAny(predicate);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    public <T> T propertyValue(BeanPropertyPredicate predicate, Class<T> type) {
        BeanProperty property = this.findAny(predicate);
        if (property != null) {
            return property.getValue(type);
        }
        return null;
    }

    public Object propertyValue(String name) {
        return this.propertyNamed(name).getValue();
    }

    public <T> T propertyValue(String name, Class<T> type) {
        return this.propertyNamed(name).getValue(type);
    }

    public boolean hasProperty(BeanPropertyPredicate predicate) {
        return this.findAny(predicate) != null;
    }

    public BeanProperty get(String name) {
        return this.propertyNamed(name);
    }

    public BeanProperty get(BeanPropertyPredicate predicate) {
        return this.findAny(predicate);
    }

    public BeanProperty propertyNamed(String name) {
        BeanProperty property = this.findAny(BeanPredicates.named(name));
        if (property == null) {
            throw new BeanPropertyNotFoundException(this.instance.getClass(), name);
        }
        return property;
    }

    public Class<?> propertyType(String name) {
        return this.propertyNamed(name).getType();
    }

    public Class<?> propertyType(BeanPropertyPredicate predicate) {
        BeanProperty found = this.findAny(predicate);
        if (found != null) {
            return found.getType();
        }
        return null;
    }

    public BeanProperty findAny(BeanPropertyPredicate predicate) {
        CapturePropertyIf visitor = new CapturePropertyIf(predicate);
        this.visit(visitor);
        return visitor.getMatchedProperty();
    }

    public void apply(BeanPropertyFunction function) {
        this.apply(function, BeanPredicates.anyProperty());
    }

    public void apply(BeanPropertyFunction function, BeanPropertyPredicate predicate) {
        this.visit(new ApplyFunctionIf(function, predicate));
    }

    public List<BeanProperty> find(BeanPropertyPredicate predicate) {
        ArrayList<BeanProperty> collection = new ArrayList<BeanProperty>();
        this.visit(new CapturePropertyToListIf(predicate, collection));
        return collection;
    }

    public void visit(BeanVisitor visitor) {
        this.inspector.inspect(this.instance, this.naming, visitor);
    }

    public boolean hasProperty(String name) {
        return this.hasProperty(BeanPredicates.named(name));
    }

    public boolean hasProperty(String name, Object value) {
        return this.hasProperty(BeanPredicates.hasPropertyValue(name, value));
    }

    public boolean setProperty(String name, Object value) {
        return this.propertyNamed(name).setValue(value);
    }

    public boolean isPropertyType(String name, Class<?> type) {
        return this.propertyNamed(name).isType(type);
    }

    public boolean isPropertyType(BeanPropertyPredicate predicate, Class<?> type) {
        return this.hasProperty(BeanPredicates.matchesAll(predicate, BeanPredicates.ofType(type)));
    }

    public void setNamingStrategy(BeanNamingStrategy naming) {
        this.naming = naming;
    }

    public void dump(Writer writer) {
        this.visit(new Print(writer));
    }

    public void dump(OutputStream os) {
        this.dump(new OutputStreamWriter(os));
    }

    public void dump(StringBuffer buffer) {
        StringWriter writer = new StringWriter();
        this.dump(writer);
        buffer.append(writer);
    }
}

