/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.beans;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.exparity.beans.core.BeanNamingStrategy;
import org.exparity.beans.core.BeanPropertyNotFoundException;
import org.exparity.beans.core.BeanPropertyOrderingStrategy;
import org.exparity.beans.core.ImmutableTypeProperty;
import org.exparity.beans.core.TypeInspector;
import org.exparity.beans.core.TypeProperty;
import org.exparity.beans.core.TypeVisitor;
import org.exparity.beans.core.Typed;
import org.exparity.beans.core.naming.CamelCaseNamingStrategy;
import org.exparity.beans.core.ordering.InAlphabeticalOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type
implements Typed {
    private final TypeInspector inspector = new TypeInspector();
    private final Class<?> type;
    private final BeanPropertyOrderingStrategy orderBy;
    private final BeanNamingStrategy naming;

    public static Type type(Class<?> type) {
        return new Type(type, new CamelCaseNamingStrategy(), new InAlphabeticalOrder());
    }

    public static Type type(Class<?> type, BeanNamingStrategy naming) {
        return new Type(type, naming, new InAlphabeticalOrder());
    }

    public static Type type(Object instance) {
        return new Type(instance.getClass(), new CamelCaseNamingStrategy(), new InAlphabeticalOrder());
    }

    public static Type type(Object instance, BeanNamingStrategy naming) {
        return new Type(instance.getClass(), naming, new InAlphabeticalOrder());
    }

    public static final TypeProperty typeProperty(Class<?> instance, String name) {
        return Type.type(instance).propertyNamed(name);
    }

    public Type(Class<?> type) {
        this(type, new CamelCaseNamingStrategy(), new InAlphabeticalOrder());
    }

    public Type(Class<?> type, BeanNamingStrategy naming, BeanPropertyOrderingStrategy orderBy) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        this.type = type;
        this.naming = naming;
        this.orderBy = orderBy;
    }

    @Override
    public String camelName() {
        return StringUtils.uncapitalize((String)this.type.getSimpleName());
    }

    @Override
    public String simpleName() {
        return this.type.getSimpleName();
    }

    public String componentName() {
        return this.isArray() ? this.type.getComponentType().getName() : this.canonicalName();
    }

    public String componentSimpleName() {
        return this.isArray() ? this.type.getComponentType().getSimpleName() : this.simpleName();
    }

    @Override
    public String canonicalName() {
        return this.type.getCanonicalName();
    }

    public boolean hasProperty(String name) {
        return this.propertyMap().containsKey(name);
    }

    public boolean isPropertyType(String name, Class<?> type) {
        return this.propertyNamed(name).isType(type);
    }

    public void visit(TypeVisitor visitor) {
        this.inspector.inspect(this.type, this.naming, visitor);
    }

    public List<TypeProperty> propertyList() {
        final ArrayList<TypeProperty> propertyList = new ArrayList<TypeProperty>();
        this.visit(new TypeVisitor(){

            public void visit(TypeProperty property) {
                propertyList.add(property);
            }
        });
        this.orderBy.sort(propertyList);
        return propertyList;
    }

    public List<ImmutableTypeProperty> accessorList() {
        return this.inspector.accessorList(this.type, this.naming);
    }

    public Map<String, TypeProperty> propertyMap() {
        final HashMap<String, TypeProperty> propertyMap = new HashMap<String, TypeProperty>();
        this.visit(new TypeVisitor(){

            public void visit(TypeProperty property) {
                propertyMap.put(property.getName(), property);
            }
        });
        return propertyMap;
    }

    public TypeProperty propertyNamed(String propertyName) {
        TypeProperty property = this.propertyMap().get(propertyName);
        if (property == null) {
            throw new BeanPropertyNotFoundException(this.type, propertyName);
        }
        return property;
    }

    public TypeProperty get(String name) {
        return this.propertyNamed(name);
    }

    public Class<?> propertyType(String name) {
        return this.propertyNamed(name).getType();
    }

    public Method getAccessor(String name) {
        for (ImmutableTypeProperty property : this.accessorList()) {
            if (!property.hasName(name)) continue;
            return property.getAccessor();
        }
        throw new BeanPropertyNotFoundException(this.type, name);
    }

    @Override
    public Class<?>[] typeHierachy() {
        return (Class[])ArrayUtils.addAll((Object[])new Class[]{this.type}, (Object[])this.superTypes());
    }

    @Override
    public Class<?>[] superTypes() {
        Class<?> superType = this.type.getSuperclass();
        if (superType.equals(Object.class)) {
            return new Class[0];
        }
        ArrayList superTypes = new ArrayList();
        while (!superType.equals(Object.class)) {
            superTypes.add(superType);
            superType = superType.getSuperclass();
        }
        return superTypes.toArray(new Class[0]);
    }

    @Override
    public boolean is(Class<?> otherType) {
        return otherType != null && otherType.isAssignableFrom(this.type);
    }

    @Override
    public boolean isArray() {
        return this.type.isArray();
    }

    @Override
    public String packageName() {
        return this.type.getPackage().getName();
    }

    @Override
    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    @Override
    public boolean isEnum() {
        return this.type.isEnum();
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public String toString() {
        return "Type [" + this.simpleName() + "]";
    }
}

