/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.tdigest.AbstractTDigest;
import org.elasticsearch.tdigest.Centroid;
import org.elasticsearch.tdigest.Dist;
import org.elasticsearch.tdigest.arrays.TDigestArrays;
import org.elasticsearch.tdigest.arrays.TDigestDoubleArray;

public class SortingDigest
extends AbstractTDigest {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(SortingDigest.class);
    private final TDigestArrays arrays;
    private boolean closed = false;
    final TDigestDoubleArray values;
    private boolean isSorted = true;

    static SortingDigest create(TDigestArrays arrays) {
        arrays.adjustBreaker(SHALLOW_SIZE);
        try {
            return new SortingDigest(arrays);
        }
        catch (Exception e) {
            arrays.adjustBreaker(-SHALLOW_SIZE);
            throw e;
        }
    }

    private SortingDigest(TDigestArrays arrays) {
        this.arrays = arrays;
        this.values = arrays.newDoubleArray(0);
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.values.ramBytesUsed();
    }

    @Override
    public void add(double x, long w) {
        SortingDigest.checkValue(x);
        this.isSorted = this.isSorted && (this.values.size() == 0 || this.values.get(this.values.size() - 1) <= x);
        int i = 0;
        while ((long)i < w) {
            this.values.add(x);
            ++i;
        }
        this.max = Math.max(this.max, x);
        this.min = Math.min(this.min, x);
    }

    @Override
    public void compress() {
        if (!this.isSorted) {
            this.values.sort();
            this.isSorted = true;
        }
    }

    @Override
    public long size() {
        return this.values.size();
    }

    @Override
    public double cdf(double x) {
        this.compress();
        return Dist.cdf(x, this.values);
    }

    @Override
    public double quantile(double q) {
        this.compress();
        return Dist.quantile(q, this.values);
    }

    @Override
    public Collection<Centroid> centroids() {
        this.compress();
        return new AbstractCollection<Centroid>(){

            @Override
            public Iterator<Centroid> iterator() {
                return new Iterator<Centroid>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < SortingDigest.this.values.size();
                    }

                    @Override
                    public Centroid next() {
                        Centroid rc = new Centroid(SortingDigest.this.values.get(this.i), 1L);
                        ++this.i;
                        return rc;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Default operation");
                    }
                };
            }

            @Override
            public int size() {
                return SortingDigest.this.values.size();
            }
        };
    }

    @Override
    public double compression() {
        return 1.0;
    }

    @Override
    public int centroidCount() {
        return this.centroids().size();
    }

    @Override
    public void reserve(long size) {
        int newSize = size + (long)this.values.size() > Integer.MAX_VALUE ? Integer.MAX_VALUE : this.values.size() + (int)size;
        this.values.ensureCapacity(newSize);
    }

    @Override
    public int byteSize() {
        return this.values.size() * 8;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.arrays.adjustBreaker(-SHALLOW_SIZE);
            Releasables.close((Releasable)this.values);
        }
    }
}

