/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geometry.utils;

import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.Polygon;

public class CircleUtils {
    static final int CIRCLE_TO_POLYGON_MINIMUM_NUMBER_OF_SIDES = 4;
    static final int CIRCLE_TO_POLYGON_MAXIMUM_NUMBER_OF_SIDES = 1000;

    private CircleUtils() {
    }

    public static Polygon createRegularGeoShapePolygon(Circle circle, int gons) {
        if (CircleUtils.slowHaversin(circle.getLat(), circle.getLon(), 90.0, 0.0) < circle.getRadiusMeters()) {
            throw new IllegalArgumentException("circle [" + circle.toString() + "] contains the north pole. It cannot be translated to a polygon");
        }
        if (CircleUtils.slowHaversin(circle.getLat(), circle.getLon(), -90.0, 0.0) < circle.getRadiusMeters()) {
            throw new IllegalArgumentException("circle [" + circle.toString() + "] contains the south pole. It cannot be translated to a polygon");
        }
        double[][] result = new double[][]{new double[gons + 1], new double[gons + 1]};
        for (int i = 0; i < gons; ++i) {
            double lon;
            double lat;
            double angle = (double)i * (360.0 / (double)gons);
            double x = Math.cos(Math.toRadians(angle));
            double y = Math.sin(Math.toRadians(angle));
            double factor = 2.0;
            double step = 1.0;
            int last = 0;
            while (true) {
                lat = circle.getLat() + y * factor;
                lon = circle.getLon() + x * factor;
                double distanceMeters = CircleUtils.slowHaversin(circle.getLat(), circle.getLon(), lat, lon);
                if (Math.abs(distanceMeters - circle.getRadiusMeters()) < 0.1) break;
                if (distanceMeters > circle.getRadiusMeters()) {
                    factor -= step;
                    if (last == 1) {
                        step /= 2.0;
                    }
                    last = -1;
                    continue;
                }
                if (!(distanceMeters < circle.getRadiusMeters())) continue;
                factor += step;
                if (last == -1) {
                    step /= 2.0;
                }
                last = 1;
            }
            result[0][i] = lon;
            result[1][i] = lat;
        }
        result[0][gons] = result[0][0];
        result[1][gons] = result[1][0];
        return new Polygon(new LinearRing(result[0], result[1]));
    }

    public static Polygon createRegularShapePolygon(Circle circle, int gons) {
        double[][] result = new double[][]{new double[gons + 1], new double[gons + 1]};
        for (int i = 0; i < gons; ++i) {
            double angle = (double)i * (360.0 / (double)gons);
            double x = circle.getRadiusMeters() * Math.cos(Math.toRadians(angle));
            double y = circle.getRadiusMeters() * Math.sin(Math.toRadians(angle));
            result[0][i] = x + circle.getX();
            result[1][i] = y + circle.getY();
        }
        result[0][gons] = result[0][0];
        result[1][gons] = result[1][0];
        return new Polygon(new LinearRing(result[0], result[1]));
    }

    public static int circleToPolygonNumSides(double radiusMeters, double errorDistance) {
        int val = (int)Math.ceil(Math.PI * 2 / Math.acos(1.0 - errorDistance / radiusMeters));
        return Math.min(1000, Math.max(4, val));
    }

    private static double slowHaversin(double lat1, double lon1, double lat2, double lon2) {
        double h1 = (1.0 - StrictMath.cos(StrictMath.toRadians(lat2) - StrictMath.toRadians(lat1))) / 2.0;
        double h2 = (1.0 - StrictMath.cos(StrictMath.toRadians(lon2) - StrictMath.toRadians(lon1))) / 2.0;
        double h = h1 + StrictMath.cos(StrictMath.toRadians(lat1)) * StrictMath.cos(StrictMath.toRadians(lat2)) * h2;
        return 1.27420175428E7 * StrictMath.asin(Math.min(1.0, Math.sqrt(h)));
    }
}

