/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.dataframe.transforms;

import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameTransformProgress {
    public static final ParseField TOTAL_DOCS = new ParseField("total_docs", new String[0]);
    public static final ParseField DOCS_REMAINING = new ParseField("docs_remaining", new String[0]);
    public static final ParseField PERCENT_COMPLETE = new ParseField("percent_complete", new String[0]);
    public static final ConstructingObjectParser<DataFrameTransformProgress, Void> PARSER = new ConstructingObjectParser("data_frame_transform_progress", true, a -> new DataFrameTransformProgress((Long)a[0], (Long)a[1], (Double)a[2]));
    private final long totalDocs;
    private final long remainingDocs;
    private final double percentComplete;

    public static DataFrameTransformProgress fromXContent(XContentParser parser) {
        return (DataFrameTransformProgress)PARSER.apply(parser, null);
    }

    public DataFrameTransformProgress(long totalDocs, Long remainingDocs, double percentComplete) {
        this.totalDocs = totalDocs;
        this.remainingDocs = remainingDocs == null ? totalDocs : remainingDocs;
        this.percentComplete = percentComplete;
    }

    public double getPercentComplete() {
        return this.percentComplete;
    }

    public long getTotalDocs() {
        return this.totalDocs;
    }

    public long getRemainingDocs() {
        return this.remainingDocs;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        DataFrameTransformProgress that = (DataFrameTransformProgress)other;
        return Objects.equals(this.remainingDocs, that.remainingDocs) && Objects.equals(this.totalDocs, that.totalDocs) && Objects.equals(this.percentComplete, that.percentComplete);
    }

    public int hashCode() {
        return Objects.hash(this.remainingDocs, this.totalDocs, this.percentComplete);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOTAL_DOCS);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), DOCS_REMAINING);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), PERCENT_COMPLETE);
    }
}

