/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.dataframe.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameTransformCheckpointStats {
    public static final ParseField TIMESTAMP_MILLIS = new ParseField("timestamp_millis", new String[0]);
    public static final ParseField TIME_UPPER_BOUND_MILLIS = new ParseField("time_upper_bound_millis", new String[0]);
    public static DataFrameTransformCheckpointStats EMPTY = new DataFrameTransformCheckpointStats(0L, 0L);
    private final long timestampMillis;
    private final long timeUpperBoundMillis;
    public static final ConstructingObjectParser<DataFrameTransformCheckpointStats, Void> LENIENT_PARSER = new ConstructingObjectParser("data_frame_transform_checkpoint_stats", true, args -> {
        long timestamp = args[0] == null ? 0L : (Long)args[0];
        long timeUpperBound = args[1] == null ? 0L : (Long)args[1];
        return new DataFrameTransformCheckpointStats(timestamp, timeUpperBound);
    });

    public static DataFrameTransformCheckpointStats fromXContent(XContentParser parser) throws IOException {
        return (DataFrameTransformCheckpointStats)LENIENT_PARSER.parse(parser, null);
    }

    public DataFrameTransformCheckpointStats(long timestampMillis, long timeUpperBoundMillis) {
        this.timestampMillis = timestampMillis;
        this.timeUpperBoundMillis = timeUpperBoundMillis;
    }

    public DataFrameTransformCheckpointStats(StreamInput in) throws IOException {
        this.timestampMillis = in.readLong();
        this.timeUpperBoundMillis = in.readLong();
    }

    public long getTimestampMillis() {
        return this.timestampMillis;
    }

    public long getTimeUpperBoundMillis() {
        return this.timeUpperBoundMillis;
    }

    public int hashCode() {
        return Objects.hash(this.timestampMillis, this.timeUpperBoundMillis);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataFrameTransformCheckpointStats that = (DataFrameTransformCheckpointStats)other;
        return this.timestampMillis == that.timestampMillis && this.timeUpperBoundMillis == that.timeUpperBoundMillis;
    }

    static {
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), TIMESTAMP_MILLIS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), TIME_UPPER_BOUND_MILLIS);
    }
}

