/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.IndexLifecycleRequestConverters;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.AcknowledgedResponse;
import org.elasticsearch.client.indexlifecycle.DeleteLifecyclePolicyRequest;
import org.elasticsearch.client.indexlifecycle.ExplainLifecycleRequest;
import org.elasticsearch.client.indexlifecycle.ExplainLifecycleResponse;
import org.elasticsearch.client.indexlifecycle.GetLifecyclePolicyRequest;
import org.elasticsearch.client.indexlifecycle.GetLifecyclePolicyResponse;
import org.elasticsearch.client.indexlifecycle.LifecycleManagementStatusRequest;
import org.elasticsearch.client.indexlifecycle.LifecycleManagementStatusResponse;
import org.elasticsearch.client.indexlifecycle.PutLifecyclePolicyRequest;
import org.elasticsearch.client.indexlifecycle.RemoveIndexLifecyclePolicyRequest;
import org.elasticsearch.client.indexlifecycle.RemoveIndexLifecyclePolicyResponse;
import org.elasticsearch.client.indexlifecycle.RetryLifecyclePolicyRequest;
import org.elasticsearch.client.indexlifecycle.StartILMRequest;
import org.elasticsearch.client.indexlifecycle.StopILMRequest;

public class IndexLifecycleClient {
    private final RestHighLevelClient restHighLevelClient;

    IndexLifecycleClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public GetLifecyclePolicyResponse getLifecyclePolicy(GetLifecyclePolicyRequest request, RequestOptions options) throws IOException {
        return (GetLifecyclePolicyResponse)this.restHighLevelClient.performRequestAndParseEntity(request, IndexLifecycleRequestConverters::getLifecyclePolicy, options, GetLifecyclePolicyResponse::fromXContent, Collections.emptySet());
    }

    public void getLifecyclePolicyAsync(GetLifecyclePolicyRequest request, RequestOptions options, ActionListener<GetLifecyclePolicyResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IndexLifecycleRequestConverters::getLifecyclePolicy, options, GetLifecyclePolicyResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse putLifecyclePolicy(PutLifecyclePolicyRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, IndexLifecycleRequestConverters::putLifecyclePolicy, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void putLifecyclePolicyAsync(PutLifecyclePolicyRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IndexLifecycleRequestConverters::putLifecyclePolicy, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteLifecyclePolicy(DeleteLifecyclePolicyRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, IndexLifecycleRequestConverters::deleteLifecyclePolicy, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteLifecyclePolicyAsync(DeleteLifecyclePolicyRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IndexLifecycleRequestConverters::deleteLifecyclePolicy, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public RemoveIndexLifecyclePolicyResponse removeIndexLifecyclePolicy(RemoveIndexLifecyclePolicyRequest request, RequestOptions options) throws IOException {
        return (RemoveIndexLifecyclePolicyResponse)this.restHighLevelClient.performRequestAndParseEntity(request, IndexLifecycleRequestConverters::removeIndexLifecyclePolicy, options, RemoveIndexLifecyclePolicyResponse::fromXContent, Collections.emptySet());
    }

    public void removeIndexLifecyclePolicyAsync(RemoveIndexLifecyclePolicyRequest request, RequestOptions options, ActionListener<RemoveIndexLifecyclePolicyResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IndexLifecycleRequestConverters::removeIndexLifecyclePolicy, options, RemoveIndexLifecyclePolicyResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse startILM(StartILMRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, IndexLifecycleRequestConverters::startILM, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void startILMAsync(StartILMRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IndexLifecycleRequestConverters::startILM, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse stopILM(StopILMRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, IndexLifecycleRequestConverters::stopILM, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public LifecycleManagementStatusResponse lifecycleManagementStatus(LifecycleManagementStatusRequest request, RequestOptions options) throws IOException {
        return (LifecycleManagementStatusResponse)this.restHighLevelClient.performRequestAndParseEntity(request, IndexLifecycleRequestConverters::lifecycleManagementStatus, options, LifecycleManagementStatusResponse::fromXContent, Collections.emptySet());
    }

    public void lifecycleManagementStatusAsync(LifecycleManagementStatusRequest request, RequestOptions options, ActionListener<LifecycleManagementStatusResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IndexLifecycleRequestConverters::lifecycleManagementStatus, options, LifecycleManagementStatusResponse::fromXContent, listener, Collections.emptySet());
    }

    public void stopILMAsync(StopILMRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IndexLifecycleRequestConverters::stopILM, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public ExplainLifecycleResponse explainLifecycle(ExplainLifecycleRequest request, RequestOptions options) throws IOException {
        return (ExplainLifecycleResponse)this.restHighLevelClient.performRequestAndParseEntity(request, IndexLifecycleRequestConverters::explainLifecycle, options, ExplainLifecycleResponse::fromXContent, Collections.emptySet());
    }

    public void explainLifecycleAsync(ExplainLifecycleRequest request, RequestOptions options, ActionListener<ExplainLifecycleResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IndexLifecycleRequestConverters::explainLifecycle, options, ExplainLifecycleResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse retryLifecyclePolicy(RetryLifecyclePolicyRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, IndexLifecycleRequestConverters::retryLifecycle, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void retryLifecyclePolicyAsync(RetryLifecyclePolicyRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IndexLifecycleRequestConverters::retryLifecycle, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }
}

