/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.STABLE, since="1.0")
public final class TestIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = ObjectStreamClass.lookup(SerializedForm.class).getFields();
    private UniqueId uniqueId;
    private UniqueId parentId;
    private String displayName;
    private String legacyReportingName;
    private TestSource source;
    private Set<TestTag> tags;
    private TestDescriptor.Type type;

    @API(status=API.Status.INTERNAL, since="1.0")
    public static TestIdentifier from(TestDescriptor testDescriptor) {
        Preconditions.notNull(testDescriptor, "TestDescriptor must not be null");
        UniqueId uniqueId = testDescriptor.getUniqueId();
        String displayName = testDescriptor.getDisplayName();
        TestSource source = testDescriptor.getSource().orElse(null);
        Set<TestTag> tags = testDescriptor.getTags();
        TestDescriptor.Type type = testDescriptor.getType();
        UniqueId parentId = testDescriptor.getParent().map(TestDescriptor::getUniqueId).orElse(null);
        String legacyReportingName = testDescriptor.getLegacyReportingName();
        return new TestIdentifier(uniqueId, displayName, source, tags, type, parentId, legacyReportingName);
    }

    private TestIdentifier(UniqueId uniqueId, String displayName, TestSource source, Set<TestTag> tags, TestDescriptor.Type type, UniqueId parentId, String legacyReportingName) {
        Preconditions.notNull(type, "TestDescriptor.Type must not be null");
        this.uniqueId = uniqueId;
        this.parentId = parentId;
        this.displayName = displayName;
        this.source = source;
        this.tags = this.copyOf(tags);
        this.type = type;
        this.legacyReportingName = legacyReportingName;
    }

    private Set<TestTag> copyOf(Set<TestTag> tags) {
        switch (tags.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(CollectionUtils.getOnlyElement(tags));
            }
        }
        return new LinkedHashSet<TestTag>(tags);
    }

    public String getUniqueId() {
        return this.uniqueId.toString();
    }

    @API(status=API.Status.STABLE, since="5.8")
    public UniqueId getUniqueIdObject() {
        return this.uniqueId;
    }

    public Optional<String> getParentId() {
        return this.getParentIdObject().map(UniqueId::toString);
    }

    @API(status=API.Status.STABLE, since="5.8")
    public Optional<UniqueId> getParentIdObject() {
        return Optional.ofNullable(this.parentId);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getLegacyReportingName() {
        return this.legacyReportingName;
    }

    public TestDescriptor.Type getType() {
        return this.type;
    }

    public boolean isTest() {
        return this.getType().isTest();
    }

    public boolean isContainer() {
        return this.getType().isContainer();
    }

    public Optional<TestSource> getSource() {
        return Optional.ofNullable(this.source);
    }

    public Set<TestTag> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestIdentifier) {
            TestIdentifier that = (TestIdentifier)obj;
            return Objects.equals(this.uniqueId, that.uniqueId);
        }
        return false;
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("uniqueId", this.uniqueId).append("parentId", this.parentId).append("displayName", this.displayName).append("legacyReportingName", this.legacyReportingName).append("source", this.source).append("tags", this.tags).append("type", (Object)this.type).toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        SerializedForm serializedForm = new SerializedForm(this);
        serializedForm.serialize(s);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        SerializedForm serializedForm = SerializedForm.deserialize(s);
        this.uniqueId = UniqueId.parse(serializedForm.uniqueId);
        this.displayName = serializedForm.displayName;
        this.source = serializedForm.source;
        this.tags = serializedForm.tags;
        this.type = serializedForm.type;
        this.parentId = UniqueId.parse(serializedForm.parentId);
        this.legacyReportingName = serializedForm.legacyReportingName;
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String uniqueId;
        private final String parentId;
        private final String displayName;
        private final String legacyReportingName;
        private final TestSource source;
        private final Set<TestTag> tags;
        private final TestDescriptor.Type type;

        SerializedForm(TestIdentifier testIdentifier) {
            this.uniqueId = testIdentifier.uniqueId.toString();
            this.parentId = testIdentifier.parentId.toString();
            this.displayName = testIdentifier.displayName;
            this.legacyReportingName = testIdentifier.legacyReportingName;
            this.source = testIdentifier.source;
            this.tags = testIdentifier.tags;
            this.type = testIdentifier.type;
        }

        private SerializedForm(ObjectInputStream.GetField fields) throws IOException {
            this.uniqueId = (String)fields.get("uniqueId", null);
            this.parentId = (String)fields.get("parentId", null);
            this.displayName = (String)fields.get("displayName", null);
            this.legacyReportingName = (String)fields.get("legacyReportingName", null);
            this.source = (TestSource)fields.get("source", null);
            this.tags = (Set)fields.get("tags", null);
            this.type = (TestDescriptor.Type)((Object)fields.get("type", null));
        }

        void serialize(ObjectOutputStream s) throws IOException {
            ObjectOutputStream.PutField fields = s.putFields();
            fields.put("uniqueId", this.uniqueId);
            fields.put("parentId", this.parentId);
            fields.put("displayName", this.displayName);
            fields.put("legacyReportingName", this.legacyReportingName);
            fields.put("source", this.source);
            fields.put("tags", this.tags);
            fields.put("type", (Object)this.type);
            s.writeFields();
        }

        static SerializedForm deserialize(ObjectInputStream s) throws ClassNotFoundException, IOException {
            ObjectInputStream.GetField fields = s.readFields();
            return new SerializedForm(fields);
        }
    }
}

