/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import org.apache.maven.surefire.api.report.SafeThrowable;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.util.internal.StringUtils;
import org.apache.maven.surefire.report.SmartStackTraceParser;

public class PojoStackTraceWriter
implements StackTraceWriter {
    private final Throwable t;
    private final String testClass;
    private final String testMethod;

    public PojoStackTraceWriter(String testClass, String testMethod, Throwable t) {
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.t = t;
    }

    public String writeTraceToString() {
        if (this.t != null) {
            String exc;
            StringWriter w = new StringWriter();
            try (PrintWriter stackTrace = new PrintWriter(w);){
                this.t.printStackTrace(stackTrace);
            }
            StringBuffer builder = w.getBuffer();
            if (PojoStackTraceWriter.isMultiLineExceptionMessage(this.t) && StringUtils.startsWith((StringBuffer)builder, (String)(exc = this.t.getClass().getName() + ": "))) {
                builder.insert(exc.length(), '\n');
            }
            return builder.toString();
        }
        return "";
    }

    public String smartTrimmedStackTrace() {
        return this.t == null ? "" : new SmartStackTraceParser(this.testClass, this.t, this.testMethod).getString();
    }

    public String writeTrimmedTraceToString() {
        return this.t == null ? "" : SmartStackTraceParser.stackTraceWithFocusOnClassAsString(this.t, this.testClass);
    }

    public SafeThrowable getThrowable() {
        return this.t == null ? null : new SafeThrowable(this.t);
    }

    private static boolean isMultiLineExceptionMessage(Throwable t) {
        String msg = t.getLocalizedMessage();
        if (msg != null) {
            int countNewLines = 0;
            int length = msg.length();
            for (int i = 0; i < length && (msg.charAt(i) != '\n' || ++countNewLines != 2); ++i) {
            }
            return countNewLines > 1 || countNewLines == 1 && !msg.trim().endsWith("\n");
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PojoStackTraceWriter that = (PojoStackTraceWriter)o;
        return Objects.equals(this.t, that.t) && Objects.equals(this.testClass, that.testClass) && Objects.equals(this.testMethod, that.testMethod);
    }

    public int hashCode() {
        return Objects.hash(this.t, this.testClass, this.testMethod);
    }
}

