/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import org.junit.jupiter.api.RepetitionInfo;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.ToStringBuilder;

class RepetitionInfoParameterResolver
implements ParameterResolver {
    private final int currentRepetition;
    private final int totalRepetitions;

    public RepetitionInfoParameterResolver(int currentRepetition, int totalRepetitions) {
        this.currentRepetition = currentRepetition;
        this.totalRepetitions = totalRepetitions;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType() == RepetitionInfo.class;
    }

    public RepetitionInfo resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return new DefaultRepetitionInfo(this.currentRepetition, this.totalRepetitions);
    }

    private static class DefaultRepetitionInfo
    implements RepetitionInfo {
        private final int currentRepetition;
        private final int totalRepetitions;

        DefaultRepetitionInfo(int currentRepetition, int totalRepetitions) {
            this.currentRepetition = currentRepetition;
            this.totalRepetitions = totalRepetitions;
        }

        public int getCurrentRepetition() {
            return this.currentRepetition;
        }

        public int getTotalRepetitions() {
            return this.totalRepetitions;
        }

        public String toString() {
            return new ToStringBuilder(this).append("currentRepetition", this.currentRepetition).append("totalRepetitions", this.totalRepetitions).toString();
        }
    }
}

