/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="5.4")
public class DefaultTestInstances
implements TestInstances {
    private final List<Object> instances;

    public static DefaultTestInstances of(Object instance) {
        return new DefaultTestInstances(Collections.singletonList(instance));
    }

    public static DefaultTestInstances of(TestInstances testInstances, Object instance) {
        ArrayList<Object> allInstances = new ArrayList<Object>(testInstances.getAllInstances());
        allInstances.add(instance);
        return new DefaultTestInstances(Collections.unmodifiableList(allInstances));
    }

    private DefaultTestInstances(List<Object> instances) {
        this.instances = Preconditions.notEmpty(instances, "instances must not be empty");
    }

    public Object getInnermostInstance() {
        return this.instances.get(this.instances.size() - 1);
    }

    public List<Object> getEnclosingInstances() {
        return this.instances.subList(0, this.instances.size() - 1);
    }

    public List<Object> getAllInstances() {
        return this.instances;
    }

    public <T> Optional<T> findInstance(Class<T> requiredType) {
        Preconditions.notNull(requiredType, "requiredType must not be null");
        ListIterator<Object> iterator = this.instances.listIterator(this.instances.size());
        while (iterator.hasPrevious()) {
            Object instance = iterator.previous();
            if (!requiredType.isInstance(instance)) continue;
            return Optional.of(requiredType.cast(instance));
        }
        return Optional.empty();
    }
}

