/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.publisher;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.tools.publisher.ResultSpyAction;
import org.eclipse.tycho.repository.util.StatusTool;

class PublisherActionRunner {
    private IMetadataRepository contextIUs;
    private List<TargetEnvironment> environments;
    private MavenLogger logger;

    public PublisherActionRunner(IMetadataRepository contextInstallableUnits, List<TargetEnvironment> environments, MavenLogger logger) {
        this.contextIUs = contextInstallableUnits;
        this.environments = environments;
        this.logger = logger;
    }

    public Collection<IInstallableUnit> executeAction(IPublisherAction action, IMetadataRepository metadataOutput, IArtifactRepository artifactOutput, IPublisherAdvice ... advice) {
        ResultSpyAction resultSpy = new ResultSpyAction();
        IPublisherAction[] actions = new IPublisherAction[]{action, resultSpy};
        IPublisherInfo publisherInfo = this.newPublisherInfo(metadataOutput, artifactOutput);
        IPublisherAdvice[] iPublisherAdviceArray = advice;
        int n = advice.length;
        int n2 = 0;
        while (n2 < n) {
            IPublisherAdvice adviceItem = iPublisherAdviceArray[n2];
            publisherInfo.addAdvice(adviceItem);
            ++n2;
        }
        Publisher publisher = new Publisher(publisherInfo);
        IStatus result = publisher.publish(actions, null);
        this.handlePublisherStatus(result);
        return resultSpy.getAllIUs();
    }

    private IPublisherInfo newPublisherInfo(IMetadataRepository metadataOutput, IArtifactRepository artifactsOutput) {
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setMetadataRepository(metadataOutput);
        publisherInfo.setArtifactRepository(artifactsOutput);
        publisherInfo.setArtifactOptions(3);
        publisherInfo.setContextMetadataRepository(this.contextIUs);
        this.setTargetEnvironments(publisherInfo);
        return publisherInfo;
    }

    private void setTargetEnvironments(PublisherInfo publisherInfo) {
        int writeIx = 0;
        String[] configSpecs = new String[this.environments.size()];
        for (TargetEnvironment environment : this.environments) {
            configSpecs[writeIx++] = environment.toConfigSpec();
        }
        publisherInfo.setConfigurations(configSpecs);
    }

    private void handlePublisherStatus(IStatus result) {
        if (result.matches(1)) {
            this.logger.info(StatusTool.collectProblems((IStatus)result));
        } else if (result.matches(2)) {
            this.logger.warn(StatusTool.collectProblems((IStatus)result));
        } else if (!result.isOK()) {
            Throwable directlyIncludedException = result.getException();
            if (directlyIncludedException instanceof RuntimeException) {
                throw (RuntimeException)directlyIncludedException;
            }
            throw new RuntimeException(StatusTool.collectProblems((IStatus)result), StatusTool.findException((IStatus)result));
        }
    }
}

