/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

public class GAV {
    private String groupId;
    private String artifactId;
    private String version;

    public GAV(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GAV)) {
            return false;
        }
        GAV other = (GAV)o;
        return GAV.equals(this.groupId, other.getGroupId()) && GAV.equals(this.artifactId, other.getArtifactId()) && GAV.equals(this.version, other.getVersion());
    }

    private static boolean equals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + (this.groupId != null ? this.groupId.hashCode() : 0);
        hash = hash * 31 + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        hash = hash * 31 + (this.version != null ? this.version.hashCode() : 0);
        return hash;
    }

    public String toExternalForm() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId).append(':').append(this.artifactId).append(':').append(this.version);
        return sb.toString();
    }

    public static GAV parse(String str) {
        if (str == null || str.trim().length() <= 0) {
            return null;
        }
        int p = 0;
        int c = GAV.nextColonIndex(str, p);
        String groupId = GAV.substring(str, p, c);
        p = c + 1;
        c = GAV.nextColonIndex(str, p);
        String artifactId = GAV.substring(str, p, c);
        p = c + 1;
        c = str.length();
        String version = GAV.substring(str, p, c);
        return new GAV(groupId, artifactId, version);
    }

    private static String substring(String str, int start, int end) {
        String substring = str.substring(start, end);
        return "".equals(substring) ? null : substring;
    }

    private static int nextColonIndex(String str, int pos) {
        int idx = str.indexOf(58, pos);
        if (idx < 0) {
            throw new IllegalArgumentException("Invalid portable string: " + str);
        }
        return idx;
    }

    public String toString() {
        return this.toExternalForm();
    }
}

