/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.util.LinkedHashSet;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.artifacts.IllegalArtifactReferenceException;
import org.eclipse.tycho.p2.target.ArtifactTypeHelper;

public class ArtifactMatcher {
    public static IInstallableUnit resolveReference(String type, String id, VersionRange versionRange, LinkedHashSet<IInstallableUnit> candidateUnits) throws IllegalArtifactReferenceException {
        if (id == null) {
            throw new IllegalArtifactReferenceException("ID is required");
        }
        IQuery query = QueryUtil.createLatestQuery(ArtifactTypeHelper.createQueryFor(type, id, versionRange));
        IQueryResult matchingIUs = query.perform(candidateUnits.iterator());
        if (matchingIUs.isEmpty()) {
            return null;
        }
        return (IInstallableUnit)matchingIUs.iterator().next();
    }

    public static Version parseAsOSGiVersion(String version) throws IllegalArtifactReferenceException {
        if (version == null) {
            return Version.emptyVersion;
        }
        try {
            return Version.parseVersion((String)version);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArtifactReferenceException("The string \"" + version + "\" is not a valid OSGi version");
        }
    }

    public static VersionRange getVersionRangeFromReference(Version version) {
        VersionRange range = version.getSegmentCount() > 3 && "qualifier".equals(version.getSegment(3)) ? ArtifactMatcher.getRangeOfEquivalentVersions(version) : (Version.emptyVersion.equals(version) ? VersionRange.emptyRange : ArtifactMatcher.getStrictRange(version));
        return range;
    }

    public static VersionRange getVersionRangeFromImport(String version, String rule) {
        FeatureEntry entry = FeatureEntry.createRequires((String)"dummy", (String)version, (String)rule, null, (boolean)false);
        class DummyFeatureAction
        extends FeaturesAction {
            public DummyFeatureAction() {
                super(new Feature[0]);
            }

            protected VersionRange getVersionRange(FeatureEntry entry) {
                VersionRange versionRange = super.getVersionRange(entry);
                if (versionRange == null) {
                    return VersionRange.emptyRange;
                }
                return versionRange;
            }
        }
        return new DummyFeatureAction().getVersionRange(entry);
    }

    private static VersionRange getStrictRange(Version version) {
        return new VersionRange(version, true, version, true);
    }

    private static VersionRange getRangeOfEquivalentVersions(Version version) {
        Integer major = (Integer)version.getSegment(0);
        Integer minor = (Integer)version.getSegment(1);
        Integer micro = (Integer)version.getSegment(2);
        VersionRange range = new VersionRange(Version.createOSGi((int)major, (int)minor, (int)micro), true, Version.createOSGi((int)major, (int)minor, (int)(micro + 1)), false);
        return range;
    }
}

