/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher.rootfiles;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.publisher.FileSetDescriptor;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.actions.IFeatureRootAdvice;
import org.eclipse.tycho.BuildProperties;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.Interpolator;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.ConfigSpec;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.FileToPathMap;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.RootFilesProperties;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.RootPropertiesParser;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.ReactorProjectFacade;

public class FeatureRootAdvice
implements IFeatureRootAdvice {
    private final String artifactId;
    private Map<ConfigSpec, RootFilesProperties> propertiesPerConfig;

    public FeatureRootAdvice(BuildProperties buildProperties, File baseDir, String artifactId) {
        RootPropertiesParser parser = new RootPropertiesParser(baseDir, buildProperties);
        parser.parse();
        this.artifactId = artifactId;
        this.propertiesPerConfig = parser.getPermissionsAndLinksResult();
    }

    public static IFeatureRootAdvice createRootFileAdvice(IArtifactFacade featureArtifact, BuildPropertiesParser buildPropertiesParser) {
        FeatureRootAdvice result;
        Interpolator interpolator = featureArtifact instanceof ReactorProjectFacade ? ((ReactorProjectFacade)featureArtifact).getReactorProject().getInterpolator() : null;
        File projectDir = FeatureRootAdvice.getProjectBaseDir(featureArtifact);
        if (projectDir != null && (result = new FeatureRootAdvice(buildPropertiesParser.parse(projectDir, interpolator), projectDir, featureArtifact.getArtifactId())).hasRootFiles()) {
            return result;
        }
        return null;
    }

    public static File getProjectBaseDir(IArtifactFacade featureArtifact) {
        File projectLocation;
        File targetDir;
        if (!"eclipse-feature".equals(featureArtifact.getPackagingType())) {
            return null;
        }
        File featureJar = featureArtifact.getLocation();
        if (featureJar != null && featureJar.isFile() && featureJar.isAbsolute() && (targetDir = featureJar.getParentFile()) != null && (projectLocation = targetDir.getParentFile()) != null) {
            return projectLocation;
        }
        return null;
    }

    private boolean hasRootFiles() {
        return this.propertiesPerConfig.size() > 0;
    }

    public boolean isApplicable(String configSpec, boolean includeDefault, String id, Version version) {
        if (id != null && !id.equals(this.artifactId)) {
            return false;
        }
        return configSpec == null || this.propertiesPerConfig.get(ConfigSpec.createFromWsOsArch(configSpec)) == null;
    }

    public String[] getConfigurations() {
        Set<ConfigSpec> configSpecs = this.propertiesPerConfig.keySet();
        ArrayList<String> result = new ArrayList<String>();
        for (ConfigSpec configSpec : configSpecs) {
            result.add(configSpec.toStringForAdvice());
        }
        return result.toArray(new String[result.size()]);
    }

    public FileUtils.IPathComputer getRootFileComputer(String configSpec) {
        final FileToPathMap filesMap = this.propertiesPerConfig.get(ConfigSpec.createFromWsOsArch(configSpec)).getFileMap();
        return new FileUtils.IPathComputer(){

            public void reset() {
            }

            public IPath computePath(File fileInSources) {
                IPath fileInInstallation = filesMap.get(fileInSources);
                return fileInInstallation;
            }
        };
    }

    public FileSetDescriptor getDescriptor(String wsOsArch) {
        ConfigSpec configuration = ConfigSpec.createFromWsOsArch(wsOsArch);
        RootFilesProperties rootProperties = this.propertiesPerConfig.get(configuration);
        if (rootProperties == null) {
            return null;
        }
        FeatureRootAdvice.ensureRootFilesConfigured(rootProperties, configuration);
        FileSetDescriptor rootFilesDescriptor = this.initDescriptor(configuration, wsOsArch);
        this.copyRootPropertiesToDescriptor(rootProperties, rootFilesDescriptor);
        return rootFilesDescriptor;
    }

    private FileSetDescriptor initDescriptor(ConfigSpec configuration, String configurationAsString) {
        String fileSetDescriptorKey = configuration.equals(ConfigSpec.GLOBAL) ? "root" : "root." + configurationAsString;
        FileSetDescriptor rootFilesDescriptor = new FileSetDescriptor(fileSetDescriptorKey, configurationAsString);
        return rootFilesDescriptor;
    }

    private void copyRootPropertiesToDescriptor(RootFilesProperties internalFormat, FileSetDescriptor externalFormat) {
        this.addFiles(internalFormat, externalFormat);
        this.addPermissions(internalFormat, externalFormat);
        this.addLinks(internalFormat, externalFormat);
    }

    private void addFiles(RootFilesProperties rootProperties, FileSetDescriptor rootFilesDescriptor) {
        FileToPathMap sourceToDestinationMap = rootProperties.getFileMap();
        if (sourceToDestinationMap == null) {
            return;
        }
        Set<File> sourceFiles = sourceToDestinationMap.keySet();
        rootFilesDescriptor.addFiles(sourceFiles.toArray(new File[sourceFiles.size()]));
    }

    private void addLinks(RootFilesProperties rootProperties, FileSetDescriptor rootFilesDescriptor) {
        if (rootProperties.getLinks() != null) {
            rootFilesDescriptor.setLinks(rootProperties.getLinks());
        }
    }

    private void addPermissions(RootFilesProperties rootProperties, FileSetDescriptor rootFilesDescriptor) {
        for (RootFilesProperties.Permission permission : rootProperties.getPermissions()) {
            for (String[] p2Format : permission.toP2Formats()) {
                rootFilesDescriptor.addPermissions(p2Format);
            }
        }
    }

    private static void ensureRootFilesConfigured(RootFilesProperties rootProperties, ConfigSpec configuration) {
        if (rootProperties.getFileMap().keySet().isEmpty()) {
            String message = configuration.equals(ConfigSpec.GLOBAL) ? "Cannot set permissions or symbolic links if there are no root files" : "Cannot set permissions or symbolic links for " + configuration.toOsString() + " if there are no root files for that configuration";
            throw new IllegalArgumentException(message);
        }
    }
}

