/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.jkube.kit.build.service.docker.config.handler.property.PropertyConfigHandler;
import org.eclipse.jkube.kit.build.service.docker.config.handler.property.PropertyMode;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;

public class ConfigHelper {
    public static final String EXTERNALCONFIG_ACTIVATION_PROPERTY = "docker.imagePropertyConfiguration";

    private ConfigHelper() {
    }

    public static List<ImageConfiguration> resolveImages(KitLogger logger, List<ImageConfiguration> images, Resolver imageResolver, String imageNameFilter, Customizer imageCustomizer) {
        List<ImageConfiguration> ret = ConfigHelper.resolveConfiguration(imageResolver, images);
        ret = imageCustomizer.customizeConfig(ret);
        List<ImageConfiguration> filtered = ConfigHelper.filterImages(imageNameFilter, ret);
        if (!ret.isEmpty() && filtered.isEmpty() && imageNameFilter != null) {
            List imageNames = ret.stream().map(ImageConfiguration::getName).collect(Collectors.toList());
            logger.warn("None of the resolved images [%s] match the configured filter '%s'", new Object[]{String.join((CharSequence)",", imageNames), imageNameFilter});
        }
        return filtered;
    }

    public static void validateExternalPropertyActivation(JavaProject project, List<ImageConfiguration> images) {
        String prop = ConfigHelper.getExternalConfigActivationProperty(project);
        if (prop == null) {
            return;
        }
        if (images.size() == 1) {
            return;
        }
        int imagesWithoutExternalConfig = 0;
        for (ImageConfiguration image : images) {
            if (PropertyConfigHandler.canCoexistWithOtherPropertyConfiguredImages(image.getExternalConfig())) continue;
            ++imagesWithoutExternalConfig;
        }
        if (imagesWithoutExternalConfig > 1) {
            throw new IllegalStateException("Configuration error: Cannot use property docker.imagePropertyConfiguration on projects with multiple images without explicit image external configuration.");
        }
    }

    public static String getExternalConfigActivationProperty(JavaProject project) {
        Properties properties = JKubeProjectUtil.getPropertiesWithSystemOverrides((JavaProject)project);
        String value = properties.getProperty(EXTERNALCONFIG_ACTIVATION_PROPERTY);
        if (PropertyMode.Skip.name().equalsIgnoreCase(value)) {
            return null;
        }
        return value;
    }

    public static String initAndValidate(List<ImageConfiguration> images, String apiVersion, NameFormatter nameFormatter) {
        for (ImageConfiguration imageConfiguration : images) {
            apiVersion = EnvUtil.extractLargerVersion((String)apiVersion, (String)ConfigHelper.initAndValidate(nameFormatter, imageConfiguration));
        }
        return apiVersion;
    }

    public static boolean matchesConfiguredImages(String imageList, ImageConfiguration imageConfig) {
        if (imageList == null) {
            return true;
        }
        HashSet<String> imagesAllowed = new HashSet<String>(Arrays.asList(imageList.split("\\s*,\\s*")));
        return imagesAllowed.contains(imageConfig.getName()) || imagesAllowed.contains(imageConfig.getAlias());
    }

    private static List<ImageConfiguration> filterImages(String nameFilter, List<ImageConfiguration> imagesToFilter) {
        ArrayList<ImageConfiguration> ret = new ArrayList<ImageConfiguration>();
        for (ImageConfiguration imageConfig : imagesToFilter) {
            if (!ConfigHelper.matchesConfiguredImages(nameFilter, imageConfig)) continue;
            ret.add(imageConfig);
        }
        return ret;
    }

    private static List<ImageConfiguration> resolveConfiguration(Resolver imageResolver, List<ImageConfiguration> unresolvedImages) {
        ArrayList<ImageConfiguration> ret = new ArrayList<ImageConfiguration>();
        if (unresolvedImages != null) {
            for (ImageConfiguration image : unresolvedImages) {
                ret.addAll(imageResolver.resolve(image));
            }
            ConfigHelper.verifyImageNames(ret);
        }
        return ret;
    }

    private static void verifyImageNames(List<ImageConfiguration> ret) {
        for (ImageConfiguration config : ret) {
            if (config.getName() != null) continue;
            throw new IllegalArgumentException("Configuration error: <image> must have a non-null <name>");
        }
    }

    public static String initAndValidate(NameFormatter nameFormatter, ImageConfiguration imageConfiguration) {
        imageConfiguration.setName(nameFormatter.format(imageConfiguration.getName()));
        String minimalApiVersion = null;
        if (imageConfiguration.getBuild() != null) {
            minimalApiVersion = imageConfiguration.getBuild().initAndValidate();
        }
        if (imageConfiguration.getRun() != null) {
            minimalApiVersion = EnvUtil.extractLargerVersion((String)minimalApiVersion, (String)imageConfiguration.getRun().initAndValidate());
        }
        return minimalApiVersion;
    }

    public static interface NameFormatter {
        public String format(String var1);
    }

    public static interface Resolver {
        public List<ImageConfiguration> resolve(ImageConfiguration var1);
    }

    public static interface Customizer {
        public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> var1);
    }
}

