/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jetty.maven.plugin.AbstractJettyMojo;

@Mojo(name="run-exploded", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class JettyRunWarExplodedMojo
extends AbstractJettyMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    private File war;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }

    @Override
    public void finishConfigurationBeforeStart() throws Exception {
        this.server.setStopAtShutdown(true);
        super.finishConfigurationBeforeStart();
    }

    @Override
    public void configureScanner() throws MojoExecutionException {
        block10: {
            try {
                File lib;
                File classes;
                File jettyEnvXmlFile;
                File jettyWebXmlFile;
                this.scanner.addFile(this.project.getFile().toPath());
                File webInfDir = new File(this.war, "WEB-INF");
                File webXml = new File(webInfDir, "web.xml");
                if (webXml.exists()) {
                    this.scanner.addFile(webXml.toPath());
                }
                if ((jettyWebXmlFile = this.findJettyWebXmlFile(webInfDir)) != null) {
                    this.scanner.addFile(jettyWebXmlFile.toPath());
                }
                if ((jettyEnvXmlFile = new File(webInfDir, "jetty-env.xml")).exists()) {
                    this.scanner.addFile(jettyEnvXmlFile.toPath());
                }
                if ((classes = new File(webInfDir, "classes")).exists()) {
                    try {
                        this.scanner.addDirectory(classes.toPath());
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error scanning classes", (Exception)e);
                    }
                }
                if (!(lib = new File(webInfDir, "lib")).exists()) break block10;
                try {
                    this.scanner.addDirectory(lib.toPath());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error scanning lib", (Exception)e);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error configuring scanner", (Exception)e);
            }
        }
    }

    @Override
    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        this.getLog().info((CharSequence)"Restarting webapp");
        this.getLog().debug((CharSequence)"Stopping webapp ...");
        this.stopScanner();
        this.webApp.stop();
        this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
        this.checkPomConfiguration();
        if (reconfigureScanner) {
            this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
            this.scanner.reset();
            this.configureScanner();
        }
        this.getLog().debug((CharSequence)"Restarting webapp ...");
        this.webApp.start();
        this.startScanner();
        this.getLog().info((CharSequence)"Restart completed.");
    }

    @Override
    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        this.webApp.setWar(this.war.getCanonicalPath());
    }
}

