/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.eclipse.jetty.http.pathmap.RegexPathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RegexPathSpecTest {
    public static void assertMatches(PathSpec spec, String path) {
        String msg = String.format("Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        MatcherAssert.assertThat((String)msg, (Object)spec.matches(path), (Matcher)Matchers.is((Object)true));
    }

    public static void assertNotMatches(PathSpec spec, String path) {
        String msg = String.format("!Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        MatcherAssert.assertThat((String)msg, (Object)spec.matches(path), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testExactSpec() {
        RegexPathSpec spec = new RegexPathSpec("^/a$");
        Assertions.assertEquals((Object)"^/a$", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/a$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)1, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.EXACT, (Object)spec.getGroup(), (String)"Spec.group");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a/");
    }

    @Test
    public void testMiddleSpec() {
        RegexPathSpec spec = new RegexPathSpec("^/rest/([^/]*)/list$");
        Assertions.assertEquals((Object)"^/rest/([^/]*)/list$", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/rest/([^/]*)/list$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)3, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.MIDDLE_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/api/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/1.0/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/2.0/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/accounts/list");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/rest/admin/delete");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/rest/list");
    }

    @Test
    public void testMiddleSpecNoGrouping() {
        RegexPathSpec spec = new RegexPathSpec("^/rest/[^/]+/list$");
        Assertions.assertEquals((Object)"^/rest/[^/]+/list$", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/rest/[^/]+/list$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)3, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.MIDDLE_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/api/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/1.0/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/2.0/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/accounts/list");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/rest/admin/delete");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/rest/list");
    }

    @Test
    public void testPrefixSpec() {
        RegexPathSpec spec = new RegexPathSpec("^/a/(.*)$");
        Assertions.assertEquals((Object)"^/a/(.*)$", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/a/(.*)$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)2, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.PREFIX_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/b");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/b/c/d/e");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb");
    }

    @Test
    public void testSuffixSpec() {
        RegexPathSpec spec = new RegexPathSpec("^(.*).do$");
        Assertions.assertEquals((Object)"^(.*).do$", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^(.*).do$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)0, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.SUFFIX_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a.do");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/b/c.do");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/abcde.do");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/abc/efg.do");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb.do/more");
    }

    @Test
    public void testEquals() {
        MatcherAssert.assertThat((Object)new RegexPathSpec("^(.*).do$"), (Matcher)Matchers.equalTo((Object)new RegexPathSpec("^(.*).do$")));
        MatcherAssert.assertThat((Object)new RegexPathSpec("/foo"), (Matcher)Matchers.equalTo((Object)new RegexPathSpec("/foo")));
        MatcherAssert.assertThat((Object)new RegexPathSpec("^(.*).do$"), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new RegexPathSpec("^(.*).gz$"))));
        MatcherAssert.assertThat((Object)new RegexPathSpec("^(.*).do$"), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new RegexPathSpec("^.*.do$"))));
        MatcherAssert.assertThat((Object)new RegexPathSpec("/foo"), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new ServletPathSpec("/foo"))));
    }
}

