/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.openjdk8.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import org.eclipse.jetty.alpn.ALPN;
import org.eclipse.jetty.alpn.client.ALPNClientConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.util.JavaVersion;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class OpenJDK8ClientALPNProcessor
implements ALPNProcessor.Client {
    private static final Logger LOG = Log.getLogger(OpenJDK8ClientALPNProcessor.class);
    private Method alpnProtocols;
    private Method alpnProtocol;

    public void init() {
        if (JavaVersion.VERSION.getPlatform() != 8) {
            throw new IllegalStateException(this + " not applicable for java " + JavaVersion.VERSION);
        }
        try {
            this.alpnProtocols = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
            this.alpnProtocol = SSLEngine.class.getMethod("getApplicationProtocol", new Class[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using OpenJDK ALPN APIs instead of Jetty ALPN APIs", new Object[0]);
            }
            return;
        }
        catch (NoSuchMethodException x) {
            LOG.ignore((Throwable)x);
            if (ALPN.class.getClassLoader() != null) {
                throw new IllegalStateException(ALPN.class.getName() + " must be on JVM boot classpath");
            }
            if (LOG.isDebugEnabled()) {
                ALPN.debug = true;
            }
            return;
        }
    }

    public boolean appliesTo(SSLEngine sslEngine) {
        return sslEngine.getClass().getName().startsWith("sun.security.ssl.");
    }

    public void configure(SSLEngine sslEngine, Connection connection) {
        ALPNClientConnection alpnConnection = (ALPNClientConnection)connection;
        if (this.alpnProtocols == null) {
            connection.addListener((Connection.Listener)new ALPNConnectionListener(alpnConnection));
        } else {
            try {
                String[] protocols = alpnConnection.getProtocols().toArray(new String[0]);
                SSLParameters sslParameters = sslEngine.getSSLParameters();
                this.alpnProtocols.invoke((Object)sslParameters, new Object[]{protocols});
                sslEngine.setSSLParameters(sslParameters);
                ((SslConnection.DecryptedEndPoint)connection.getEndPoint()).getSslConnection().addHandshakeListener((SslHandshakeListener)new ALPNSSLListener(alpnConnection));
            }
            catch (IllegalAccessException | InvocationTargetException x) {
                throw new IllegalStateException(this + " unable to set ALPN protocols", x);
            }
        }
    }

    private static final class ALPNConnectionListener
    implements ALPN.ClientProvider,
    Connection.Listener {
        private final ALPNClientConnection alpnConnection;

        private ALPNConnectionListener(ALPNClientConnection connection) {
            this.alpnConnection = connection;
        }

        public void onOpened(Connection connection) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onOpened {}", new Object[]{this.alpnConnection});
            }
            ALPN.put((SSLEngine)this.alpnConnection.getSSLEngine(), (ALPN.Provider)this);
        }

        public void onClosed(Connection connection) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onClosed {}", new Object[]{this.alpnConnection});
            }
            ALPN.remove((SSLEngine)this.alpnConnection.getSSLEngine());
        }

        public List<String> protocols() {
            return this.alpnConnection.getProtocols();
        }

        public void unsupported() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("unsupported {}", new Object[]{this.alpnConnection});
            }
            ALPN.remove((SSLEngine)this.alpnConnection.getSSLEngine());
            this.alpnConnection.selected(null);
        }

        public void selected(String protocol) {
            this.alpnConnection.selected(protocol);
        }
    }

    private final class ALPNSSLListener
    implements SslHandshakeListener {
        private final ALPNClientConnection alpnConnection;

        private ALPNSSLListener(ALPNClientConnection connection) {
            this.alpnConnection = connection;
        }

        public void handshakeSucceeded(SslHandshakeListener.Event event) throws SSLException {
            try {
                SSLEngine sslEngine = this.alpnConnection.getSSLEngine();
                String protocol = (String)OpenJDK8ClientALPNProcessor.this.alpnProtocol.invoke((Object)sslEngine, new Object[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("selected protocol {}", new Object[]{protocol});
                }
                this.alpnConnection.selected(protocol);
            }
            catch (IllegalAccessException | InvocationTargetException x) {
                SSLHandshakeException failure = new SSLHandshakeException(this + " unable to get ALPN protocol");
                throw (SSLHandshakeException)failure.initCause(x);
            }
        }
    }
}

