/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.parser;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.frames.SettingsFrame;
import org.eclipse.jetty.http3.internal.VarLenInt;
import org.eclipse.jetty.http3.parser.BodyParser;
import org.eclipse.jetty.http3.parser.HeaderParser;
import org.eclipse.jetty.http3.parser.ParserListener;

public class SettingsBodyParser
extends BodyParser {
    private final VarLenInt varLenInt = new VarLenInt();
    private State state = State.INIT;
    private long length;
    private long key;
    private Map<Long, Long> settings;

    public SettingsBodyParser(HeaderParser headerParser, ParserListener listener) {
        super(headerParser, listener);
    }

    private void reset() {
        this.varLenInt.reset();
        this.state = State.INIT;
        this.length = 0L;
        this.key = 0L;
        this.settings = null;
    }

    @Override
    protected void emptyBody(ByteBuffer buffer) {
        this.onSettings(Map.of());
    }

    @Override
    public BodyParser.Result parse(ByteBuffer buffer) {
        block5: while (buffer.hasRemaining()) {
            switch (this.state.ordinal()) {
                case 0: {
                    this.length = this.getBodyLength();
                    this.settings = new LinkedHashMap<Long, Long>();
                    this.state = State.KEY;
                    continue block5;
                }
                case 1: {
                    if (this.varLenInt.decode(buffer, v -> {
                        this.key = v;
                        this.length -= (long)VarLenInt.length(v);
                    })) {
                        if (this.settings.containsKey(this.key)) {
                            this.sessionFailure(buffer, HTTP3ErrorCode.SETTINGS_ERROR.code(), "settings_duplicate", new IllegalArgumentException("invalid duplicate setting"));
                            return BodyParser.Result.NO_FRAME;
                        }
                        if (SettingsFrame.isReserved(this.key)) {
                            this.sessionFailure(buffer, HTTP3ErrorCode.SETTINGS_ERROR.code(), "settings_reserved", new IllegalArgumentException("invalid reserved setting"));
                            return BodyParser.Result.NO_FRAME;
                        }
                        if (this.length > 0L) {
                            this.state = State.VALUE;
                            continue block5;
                        }
                        this.sessionFailure(buffer, HTTP3ErrorCode.FRAME_ERROR.code(), "settings_invalid_format", new IllegalArgumentException("invalid setting"));
                        return BodyParser.Result.NO_FRAME;
                    }
                    return BodyParser.Result.NO_FRAME;
                }
                case 2: {
                    if (this.varLenInt.decode(buffer, v -> {
                        this.settings.put(this.key, v);
                        this.length -= (long)VarLenInt.length(v);
                    })) {
                        if (this.length > 0L) {
                            this.state = State.KEY;
                            continue block5;
                        }
                        if (this.length == 0L) {
                            Map<Long, Long> settings = this.settings;
                            this.reset();
                            this.onSettings(settings);
                            return BodyParser.Result.WHOLE_FRAME;
                        }
                        this.sessionFailure(buffer, HTTP3ErrorCode.FRAME_ERROR.code(), "settings_invalid_format", new IllegalArgumentException("invalid setting"));
                        return BodyParser.Result.NO_FRAME;
                    }
                    return BodyParser.Result.NO_FRAME;
                }
            }
            throw new IllegalStateException();
        }
        return BodyParser.Result.NO_FRAME;
    }

    private void onSettings(Map<Long, Long> settings) {
        SettingsFrame frame = new SettingsFrame(settings);
        this.notifySettings(frame);
    }

    private static enum State {
        INIT,
        KEY,
        VALUE;

    }
}

