/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client.transport.internal;

import java.nio.channels.AsynchronousCloseException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpConnection;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.SendFailure;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http3.client.HTTP3SessionClient;
import org.eclipse.jetty.http3.client.transport.internal.HttpChannelOverHTTP3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionOverHTTP3
extends HttpConnection
implements ConnectionPool.MaxMultiplexable,
ConnectionPool.MaxUsable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConnectionOverHTTP3.class);
    private final Set<HttpChannel> activeChannels = ConcurrentHashMap.newKeySet();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final HTTP3SessionClient session;

    public HttpConnectionOverHTTP3(Destination destination, HTTP3SessionClient session) {
        super((HttpDestination)destination);
        this.session = session;
    }

    public HTTP3SessionClient getSession() {
        return this.session;
    }

    public int getMaxMultiplex() {
        return this.getMaxUsage();
    }

    public int getMaxUsage() {
        return this.session.getMaxLocalStreams();
    }

    protected Iterator<HttpChannel> getHttpChannels() {
        return this.activeChannels.iterator();
    }

    public SendFailure send(HttpExchange exchange) {
        HttpRequest request = exchange.getRequest();
        request.version(HttpVersion.HTTP_3);
        this.normalizeRequest(request);
        HttpChannelOverHTTP3 channel = this.newHttpChannel();
        this.activeChannels.add(channel);
        return this.send(channel, exchange);
    }

    protected HttpChannelOverHTTP3 newHttpChannel() {
        return new HttpChannelOverHTTP3(this, this.getSession());
    }

    public void release(HttpChannelOverHTTP3 channel) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("released {}", (Object)channel);
        }
        if (this.activeChannels.remove((Object)channel)) {
            this.getHttpDestination().release((Connection)this);
        } else {
            channel.destroy();
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void close() {
        this.close(new AsynchronousCloseException());
    }

    public void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().remove((Connection)this);
            this.abort(failure);
            this.session.goAway(false);
            this.destroy();
        }
    }

    private void abort(Throwable failure) {
        for (HttpChannel channel : this.activeChannels) {
            HttpExchange exchange = channel.getHttpExchange();
            if (exchange == null) continue;
            exchange.getRequest().abort(failure);
        }
        this.activeChannels.clear();
    }

    public boolean onIdleTimeout(long idleTimeout, Throwable failure) {
        if (super.onIdleTimeout(idleTimeout, failure)) {
            this.close(failure);
        }
        return false;
    }
}

