/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client.transport;

import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http3.client.HTTP3Client;
import org.eclipse.jetty.http3.client.HTTP3ClientConnectionFactory;
import org.eclipse.jetty.http3.client.transport.internal.SessionClientListener;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class ClientConnectionFactoryOverHTTP3
extends ContainerLifeCycle
implements ClientConnectionFactory {
    private final HTTP3ClientConnectionFactory factory = new HTTP3ClientConnectionFactory();
    private final HTTP3Client client;

    public ClientConnectionFactoryOverHTTP3(HTTP3Client client) {
        this.client = client;
        this.addBean(client);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        return this.factory.newConnection(endPoint, context);
    }

    public static class HTTP3
    extends ClientConnectionFactory.Info
    implements ProtocolSession.Factory {
        public HTTP3(HTTP3Client client) {
            super((ClientConnectionFactory)new ClientConnectionFactoryOverHTTP3(client));
        }

        public List<String> getProtocols(boolean secure) {
            return List.of("h3");
        }

        public ProtocolSession newProtocolSession(QuicSession quicSession, Map<String, Object> context) {
            ClientConnectionFactoryOverHTTP3 http3 = (ClientConnectionFactoryOverHTTP3)this.getClientConnectionFactory();
            context.put(HTTP3Client.CLIENT_CONTEXT_KEY, http3.client);
            SessionClientListener listener = new SessionClientListener(context);
            context.put(HTTP3Client.SESSION_LISTENER_CONTEXT_KEY, listener);
            return http3.factory.newProtocolSession(quicSession, context);
        }

        public String toString() {
            return String.format("%s@%x", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode());
        }
    }
}

