/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap.set;

import java.io.Externalizable;
import java.io.Serializable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.multimap.set.ImmutableSetMultimap;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;
import org.eclipse.collections.impl.multimap.AbstractSynchronizedPutMultimap;
import org.eclipse.collections.impl.multimap.bag.HashBagMultimap;
import org.eclipse.collections.impl.multimap.set.ImmutableSetMultimapImpl;
import org.eclipse.collections.impl.multimap.set.UnifiedSetMultimap;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.Iterate;

public final class SynchronizedPutUnifiedSetMultimap<K, V>
extends AbstractSynchronizedPutMultimap<K, V, MutableSet<V>>
implements MutableSetMultimap<K, V>,
Externalizable {
    private static final long serialVersionUID = 42L;

    public SynchronizedPutUnifiedSetMultimap() {
    }

    public SynchronizedPutUnifiedSetMultimap(int initialCapacity) {
        super(ConcurrentHashMap.newMap(initialCapacity));
    }

    public SynchronizedPutUnifiedSetMultimap(Multimap<? extends K, ? extends V> multimap) {
        this.putAll(multimap);
    }

    public SynchronizedPutUnifiedSetMultimap(Pair<K, V> ... pairs) {
        this();
        ArrayIterate.forEach(pairs, (Procedure & Serializable)pair -> this.put(pair.getOne(), pair.getTwo()));
    }

    public SynchronizedPutUnifiedSetMultimap(Iterable<Pair<K, V>> inputIterable) {
        this();
        Iterate.forEach(inputIterable, arg_0 -> this.add(arg_0));
    }

    @Override
    public SynchronizedPutUnifiedSetMultimap<K, V> withKeyMultiValues(K key, V ... values) {
        return (SynchronizedPutUnifiedSetMultimap)super.withKeyMultiValues(key, values);
    }

    public static <K, V> SynchronizedPutUnifiedSetMultimap<K, V> newMultimap() {
        return new SynchronizedPutUnifiedSetMultimap<K, V>();
    }

    public static <K, V> SynchronizedPutUnifiedSetMultimap<K, V> newMultimap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new SynchronizedPutUnifiedSetMultimap<K, V>(initialCapacity);
    }

    public static <K, V> SynchronizedPutUnifiedSetMultimap<K, V> newMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new SynchronizedPutUnifiedSetMultimap<K, V>(multimap);
    }

    public static <K, V> SynchronizedPutUnifiedSetMultimap<K, V> newMultimap(Pair<K, V> ... pairs) {
        return new SynchronizedPutUnifiedSetMultimap<K, V>(pairs);
    }

    public static <K, V> SynchronizedPutUnifiedSetMultimap<K, V> newMultimap(Iterable<Pair<K, V>> inputIterable) {
        return new SynchronizedPutUnifiedSetMultimap<K, V>(inputIterable);
    }

    @Override
    protected MutableSet<V> createCollection() {
        return Sets.mutable.withInitialCapacity(1);
    }

    public void forEachKeyMutableSet(Procedure2<? super K, ? super MutableSet<V>> procedure) {
        this.getMap().forEachKeyValue((Procedure2 & Serializable)(key, value) -> procedure.value(key, (Object)value.asUnmodifiable()));
    }

    public SynchronizedPutUnifiedSetMultimap<K, V> newEmpty() {
        return new SynchronizedPutUnifiedSetMultimap<K, V>();
    }

    public MutableSetMultimap<K, V> toMutable() {
        return new SynchronizedPutUnifiedSetMultimap<K, V>(this);
    }

    public ImmutableSetMultimap<K, V> toImmutable() {
        MutableMap map = Maps.mutable.empty();
        this.map.forEachKeyValue((Procedure2 & Serializable)(key, set) -> {
            ImmutableSet cfr_ignored_0 = (ImmutableSet)map.put(key, (Object)set.toImmutable());
        });
        return new ImmutableSetMultimapImpl(map);
    }

    public UnifiedSetMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return this.selectKeysValues(predicate, UnifiedSetMultimap.newMultimap());
    }

    public UnifiedSetMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return this.rejectKeysValues(predicate, UnifiedSetMultimap.newMultimap());
    }

    public UnifiedSetMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super RichIterable<V>> predicate) {
        return this.selectKeysMultiValues(predicate, UnifiedSetMultimap.newMultimap());
    }

    public UnifiedSetMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super RichIterable<V>> predicate) {
        return this.rejectKeysMultiValues(predicate, UnifiedSetMultimap.newMultimap());
    }

    public <K2, V2> MutableBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return this.collectKeysValues(function, HashBagMultimap.newMultimap());
    }

    public <K2, V2> MutableBagMultimap<K2, V2> collectKeyMultiValues(Function<? super K, ? extends K2> keyFunction, Function<? super V, ? extends V2> valueFunction) {
        return this.collectKeyMultiValues(keyFunction, valueFunction, HashBagMultimap.newMultimap());
    }

    public <V2> MutableBagMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        return this.collectValues(function, HashBagMultimap.newMultimap());
    }

    public MutableSetMultimap<V, K> flip() {
        return Iterate.flip(this);
    }

    public MutableSetMultimap<K, V> asSynchronized() {
        throw new UnsupportedOperationException("Cannot call asSynchronized() on " + this.getClass().getSimpleName());
    }
}

