/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.FloatBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.iterator.MutableFloatIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.FloatIntPair;
import org.eclipse.collections.impl.Counter;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.SynchronizedFloatBag;
import org.eclipse.collections.impl.bag.mutable.primitive.UnmodifiableFloatBag;
import org.eclipse.collections.impl.block.factory.primitive.IntToIntFunctions;
import org.eclipse.collections.impl.factory.primitive.FloatBags;
import org.eclipse.collections.impl.factory.primitive.FloatSets;
import org.eclipse.collections.impl.map.mutable.primitive.FloatIntHashMap;
import org.eclipse.collections.impl.primitive.AbstractFloatIterable;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class FloatHashBag
extends AbstractFloatIterable
implements MutableFloatBag,
Externalizable {
    private static final long serialVersionUID = 1L;
    private FloatIntHashMap items;
    private int size;

    public FloatHashBag() {
        this.items = new FloatIntHashMap();
    }

    public FloatHashBag(int size) {
        this.items = new FloatIntHashMap(size);
    }

    public FloatHashBag(FloatIterable iterable) {
        this();
        this.addAll(iterable);
    }

    public FloatHashBag(float ... elements) {
        this();
        this.addAll(elements);
    }

    public FloatHashBag(FloatHashBag bag) {
        this.items = new FloatIntHashMap(bag.sizeDistinct());
        this.addAll(bag);
    }

    public static FloatHashBag newBag(int size) {
        return new FloatHashBag(size);
    }

    public static FloatHashBag newBagWith(float ... source) {
        return new FloatHashBag(source);
    }

    public static FloatHashBag newBag(FloatIterable source) {
        if (source instanceof FloatHashBag) {
            return new FloatHashBag((FloatHashBag)source);
        }
        return new FloatHashBag(source);
    }

    public static FloatHashBag newBag(FloatBag source) {
        return new FloatHashBag((FloatIterable)source);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean notEmpty() {
        return this.items.notEmpty();
    }

    public int size() {
        return this.size;
    }

    public int sizeDistinct() {
        return this.items.size();
    }

    public void clear() {
        this.items.clear();
        this.size = 0;
    }

    public FloatHashBag with(float element) {
        this.add(element);
        return this;
    }

    public FloatHashBag with(float element1, float element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public FloatHashBag with(float element1, float element2, float element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    public FloatHashBag withAll(FloatIterable iterable) {
        this.addAll(iterable);
        return this;
    }

    public FloatHashBag without(float element) {
        this.remove(element);
        return this;
    }

    public FloatHashBag withoutAll(FloatIterable iterable) {
        this.removeAll(iterable);
        return this;
    }

    public boolean contains(float value) {
        return this.items.containsKey(value);
    }

    public int occurrencesOf(float item) {
        return this.items.get(item);
    }

    public void forEachWithOccurrences(FloatIntProcedure procedure) {
        this.items.forEachKeyValue(procedure);
    }

    public FloatHashBag selectByOccurrences(IntPredicate predicate) {
        FloatHashBag result = new FloatHashBag();
        this.forEachWithOccurrences((FloatIntProcedure & Serializable)(each, occurrences) -> {
            if (predicate.accept(occurrences)) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    public MutableFloatSet selectUnique() {
        MutableFloatSet result = FloatSets.mutable.empty();
        this.forEachWithOccurrences((FloatIntProcedure & Serializable)(each, occurrences) -> {
            if (occurrences == 1) {
                result.add(each);
            }
        });
        return result;
    }

    public MutableList<FloatIntPair> topOccurrences(int count) {
        return this.occurrencesSortingBy(count, (IntFunction<FloatIntPair>)(IntFunction & Serializable)item -> -item.getTwo(), (MutableList<FloatIntPair>)Lists.mutable.empty());
    }

    public MutableList<FloatIntPair> bottomOccurrences(int count) {
        return this.occurrencesSortingBy(count, (IntFunction<FloatIntPair>)((IntFunction & Serializable)FloatIntPair::getTwo), (MutableList<FloatIntPair>)Lists.mutable.empty());
    }

    protected MutableList<FloatIntPair> occurrencesSortingBy(int n, IntFunction<FloatIntPair> function, MutableList<FloatIntPair> returnWhenEmpty) {
        int keySize;
        if (n < 0) {
            throw new IllegalArgumentException("Cannot use a value of n < 0");
        }
        if (n == 0) {
            return returnWhenEmpty;
        }
        MutableList sorted = this.toListWithOccurrences().sortThisByInt(function);
        MutableList results = sorted.subList(0, keySize).toList();
        for (keySize = Math.min(n, this.sizeDistinct()); keySize < sorted.size() && ((FloatIntPair)results.getLast()).getTwo() == ((FloatIntPair)sorted.get(keySize)).getTwo(); ++keySize) {
            results.add(sorted.get(keySize));
        }
        return results;
    }

    protected MutableList<FloatIntPair> toListWithOccurrences() {
        MutableList result = Lists.mutable.withInitialCapacity(this.sizeDistinct());
        this.forEachWithOccurrences((FloatIntProcedure & Serializable)(each, count) -> result.add((Object)PrimitiveTuples.pair(each, count)));
        return result;
    }

    public boolean add(float item) {
        this.items.updateValue(item, 0, IntToIntFunctions.increment());
        ++this.size;
        return true;
    }

    public boolean remove(float item) {
        int newValue = this.items.updateValue(item, 0, IntToIntFunctions.decrement());
        if (newValue <= 0) {
            this.items.removeKey(item);
            if (newValue == 0) {
                --this.size;
            }
            return newValue == 0;
        }
        --this.size;
        return true;
    }

    public boolean removeIf(FloatPredicate predicate) {
        boolean changed = false;
        MutableFloatIterator iterator = this.items.keySet().floatIterator();
        while (iterator.hasNext()) {
            float key = iterator.next();
            if (!predicate.accept(key)) continue;
            this.size -= this.items.get(key);
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    public boolean addAll(float ... source) {
        if (source.length == 0) {
            return false;
        }
        for (float each : source) {
            this.add(each);
        }
        return true;
    }

    public boolean addAll(FloatIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        if (source instanceof FloatBag) {
            FloatBag otherBag = (FloatBag)source;
            otherBag.forEachWithOccurrences(this::addOccurrences);
        } else {
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                float each = iterator.next();
                this.add(each);
            }
        }
        return true;
    }

    public boolean removeAll(float ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (float each : source) {
            int occurrences = this.items.removeKeyIfAbsent(each, 0);
            this.size -= occurrences;
        }
        return this.size() != oldSize;
    }

    public boolean removeAll(FloatIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof FloatBag) {
            FloatBag otherBag = (FloatBag)source;
            otherBag.forEachWithOccurrences((FloatIntProcedure & Serializable)(each, occurrences) -> {
                int oldOccurrences = this.items.removeKeyIfAbsent(each, 0);
                this.size -= oldOccurrences;
            });
        } else {
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                float each2 = iterator.next();
                int occurrences2 = this.items.removeKeyIfAbsent(each2, 0);
                this.size -= occurrences2;
            }
        }
        return this.size() != oldSize;
    }

    public boolean retainAll(FloatIterable source) {
        int oldSize = this.size();
        FloatSet sourceSet = source instanceof FloatSet ? (FloatSet)source : source.toSet();
        FloatHashBag retained = this.select(arg_0 -> ((FloatSet)sourceSet).contains(arg_0));
        if (retained.size() != oldSize) {
            this.items = retained.items;
            this.size = retained.size;
            return true;
        }
        return false;
    }

    public boolean retainAll(float ... source) {
        return this.retainAll(FloatHashSet.newSetWith(source));
    }

    public void addOccurrences(float item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot add a negative number of occurrences");
        }
        if (occurrences > 0) {
            this.items.updateValue(item, 0, (IntToIntFunction & Serializable)intParameter -> intParameter + occurrences);
            this.size += occurrences;
        }
    }

    public boolean removeOccurrences(float item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot remove a negative number of occurrences");
        }
        if (occurrences == 0) {
            return false;
        }
        int newValue = this.items.updateValue(item, 0, (IntToIntFunction & Serializable)intParameter -> intParameter - occurrences);
        if (newValue <= 0) {
            this.size -= occurrences - newValue;
            this.items.removeKey(item);
            return newValue + occurrences != 0;
        }
        this.size -= occurrences;
        return true;
    }

    public void each(FloatProcedure procedure) {
        this.items.forEachKeyValue((FloatIntProcedure & Serializable)(key, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                procedure.value(key);
            }
        });
    }

    public FloatHashBag select(FloatPredicate predicate) {
        FloatHashBag result = new FloatHashBag();
        this.forEachWithOccurrences((FloatIntProcedure & Serializable)(each, occurrences) -> {
            if (predicate.accept(each)) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    public FloatHashBag reject(FloatPredicate predicate) {
        FloatHashBag result = new FloatHashBag();
        this.forEachWithOccurrences((FloatIntProcedure & Serializable)(each, occurrences) -> {
            if (!predicate.accept(each)) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        Object[] result = new Object[]{injectedValue};
        this.forEachWithOccurrences((FloatIntProcedure & Serializable)(each, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                result[0] = function.valueOf(result[0], each);
            }
        });
        return (T)result[0];
    }

    public RichIterable<FloatIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)FloatBags.mutable.withAll((FloatIterable)this));
            } else {
                MutableFloatIterator iterator = this.floatIterator();
                while (iterator.hasNext()) {
                    MutableFloatBag batch = FloatBags.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch);
                }
            }
        }
        return result;
    }

    public boolean equals(Object otherBag) {
        if (otherBag == this) {
            return true;
        }
        if (!(otherBag instanceof FloatBag)) {
            return false;
        }
        FloatBag bag = (FloatBag)otherBag;
        if (this.sizeDistinct() != bag.sizeDistinct()) {
            return false;
        }
        return this.items.keysView().allSatisfy((FloatPredicate & Serializable)key -> this.occurrencesOf(key) == bag.occurrencesOf(key));
    }

    public int hashCode() {
        Counter result = new Counter();
        this.forEachWithOccurrences((FloatIntProcedure & Serializable)(eachItem, occurrences) -> result.add(Float.floatToIntBits(eachItem) ^ occurrences));
        return result.getCount();
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        boolean[] firstItem = new boolean[]{true};
        try {
            appendable.append(start);
            this.items.forEachKeyValue((FloatIntProcedure & Serializable)(each, occurrences) -> {
                try {
                    for (int i = 0; i < occurrences; ++i) {
                        if (!firstItem[0]) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(each));
                        firstItem[0] = false;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int count(FloatPredicate predicate) {
        Counter result = new Counter();
        this.forEachWithOccurrences((FloatIntProcedure & Serializable)(each, occurrences) -> {
            if (predicate.accept(each)) {
                result.add(occurrences);
            }
        });
        return result.getCount();
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return this.items.keysView().anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return this.items.keysView().allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.items.keysView().noneSatisfy(predicate);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.items.keysView().detectIfNone(predicate, ifNone);
    }

    public <V> MutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        HashBag result = HashBag.newBag(this.items.size());
        this.forEachWithOccurrences((FloatIntProcedure & Serializable)(each, occurrences) -> result.addOccurrences(function.valueOf(each), occurrences));
        return result;
    }

    public float max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().max();
    }

    public float min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().min();
    }

    public double sum() {
        double[] result = new double[]{0.0};
        double[] compensation = new double[]{0.0};
        this.forEachWithOccurrences((FloatIntProcedure & Serializable)(each, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                double adjustedValue = (double)each - compensation[0];
                double nextSum = result[0] + adjustedValue;
                compensation[0] = nextSum - result[0] - adjustedValue;
                result[0] = nextSum;
            }
        });
        return result[0];
    }

    public float[] toArray() {
        float[] array = new float[this.size()];
        int[] index = new int[]{0};
        this.forEachWithOccurrences((FloatIntProcedure & Serializable)(each, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                array[index[0]] = each;
                index[0] = index[0] + 1;
            }
        });
        return array;
    }

    public float[] toArray(float[] array) {
        if (array.length < this.size()) {
            array = new float[this.size()];
        }
        int[] index = new int[]{0};
        float[] finalBypass = array;
        this.forEachWithOccurrences((FloatIntProcedure & Serializable)(each, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                finalBypass[index[0]] = each;
                index[0] = index[0] + 1;
            }
        });
        return array;
    }

    public MutableFloatBag asUnmodifiable() {
        return new UnmodifiableFloatBag(this);
    }

    public MutableFloatBag asSynchronized() {
        return new SynchronizedFloatBag(this);
    }

    public ImmutableFloatBag toImmutable() {
        return FloatBags.immutable.withAll((FloatIterable)this);
    }

    public FloatHashBag newEmpty() {
        return new FloatHashBag();
    }

    public MutableFloatIterator floatIterator() {
        return new InternalIterator();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.items.size());
        try {
            this.items.forEachKeyValue((FloatIntProcedure & Serializable)(each, occurrences) -> {
                try {
                    out.writeFloat(each);
                    out.writeInt(occurrences);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        this.items = new FloatIntHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.addOccurrences(in.readFloat(), in.readInt());
        }
    }

    private class InternalIterator
    implements MutableFloatIterator {
        private MutableFloatIterator floatIterator;
        private float currentItem;
        private int occurrences;
        private boolean canRemove;

        private InternalIterator() {
            this.floatIterator = FloatHashBag.this.items.keySet().floatIterator();
        }

        public boolean hasNext() {
            return this.occurrences > 0 || this.floatIterator.hasNext();
        }

        public float next() {
            if (this.occurrences == 0) {
                this.currentItem = this.floatIterator.next();
                this.occurrences = FloatHashBag.this.occurrencesOf(this.currentItem);
            }
            --this.occurrences;
            this.canRemove = true;
            return this.currentItem;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            if (this.occurrences == 0) {
                this.floatIterator.remove();
                FloatHashBag.this.size--;
            } else {
                FloatHashBag.this.remove(this.currentItem);
            }
            this.canRemove = false;
        }
    }
}

