/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.fest.assertions.internal.BinaryDiffResult;
import org.fest.util.VisibleForTesting;

class BinaryDiff {
    BinaryDiff() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BinaryDiffResult diff(File actual, byte[] expected) throws IOException {
        ByteArrayInputStream expectedStream = new ByteArrayInputStream(expected);
        FileInputStream actualStream = null;
        boolean threw = true;
        try {
            actualStream = new FileInputStream(actual);
            BinaryDiffResult result = this.diff(actualStream, expectedStream);
            threw = false;
            BinaryDiffResult binaryDiffResult = result;
            return binaryDiffResult;
        }
        finally {
            block8: {
                try {
                    if (actualStream != null) {
                        ((InputStream)actualStream).close();
                    }
                }
                catch (IOException e) {
                    if (threw) break block8;
                    throw e;
                }
            }
        }
    }

    @VisibleForTesting
    BinaryDiffResult diff(InputStream actualStream, InputStream expectedStream) throws IOException {
        int index = 0;
        while (true) {
            int actual = actualStream.read();
            int expected = expectedStream.read();
            if (actual == -1 && expected == -1) {
                return BinaryDiffResult.noDiff();
            }
            if (actual != expected) {
                return new BinaryDiffResult(index, expected, actual);
            }
            ++index;
        }
    }
}

