/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.internal.Booleans;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanAssert
extends AbstractAssert<BooleanAssert, Boolean> {
    @VisibleForTesting
    Booleans booleans = Booleans.instance();

    protected BooleanAssert(Boolean actual) {
        super(actual, BooleanAssert.class);
    }

    public BooleanAssert isTrue() {
        return this.isEqualTo(true);
    }

    public BooleanAssert isFalse() {
        return this.isEqualTo(false);
    }

    @Override
    public BooleanAssert isEqualTo(boolean expected) {
        this.booleans.assertEqual(this.info, (Boolean)this.actual, expected);
        return this;
    }

    @Override
    public BooleanAssert isNotEqualTo(boolean other) {
        this.booleans.assertNotEqual(this.info, (Boolean)this.actual, other);
        return this;
    }

    @Override
    public BooleanAssert usingComparator(Comparator<? super Boolean> customComparator) {
        throw new UnsupportedOperationException("custom Comparator is not supported for Boolean comparison");
    }
}

