/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.base.rule.EntryPointId;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.QueryElementFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.marshalling.MarshallerReaderContext;
import org.drools.core.marshalling.TupleKey;
import org.drools.core.phreak.PhreakTimerNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.TupleImpl;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.serialization.protobuf.ProtobufInputMarshaller;
import org.drools.serialization.protobuf.ProtobufMessages;
import org.drools.serialization.protobuf.TimersInputMarshaller;
import org.drools.serialization.protobuf.marshalling.ObjectMarshallingStrategyStoreImpl;
import org.drools.serialization.protobuf.marshalling.RightTupleKey;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieRuntime;
import org.kie.internal.marshalling.MarshallerFactory;

public class ProtobufMarshallerReaderContext
extends ObjectInputStream
implements MarshallerReaderContext {
    private final InternalKnowledgeBase kBase;
    private InternalWorkingMemory wm;
    public KieRuntime kruntime;
    private final Map<Integer, BaseNode> sinks;
    private Map<Long, InternalFactHandle> handles;
    public final Map<RightTupleKey, RightTuple> rightTuples;
    private final Map<Integer, LeftTuple> terminalTupleMap;
    private final ProtobufInputMarshaller.PBActivationsFilter filter;
    private final ObjectMarshallingStrategyStore resolverStrategyFactory;
    private final Map<Integer, ObjectMarshallingStrategy> usedStrategies;
    private final Map<ObjectMarshallingStrategy, ObjectMarshallingStrategy.Context> strategyContexts;
    public final Map<String, EntryPointId> entryPoints;
    private final Map<Integer, TimersInputMarshaller> readersByInt;
    private final Map<Long, PropagationContext> propagationContexts;
    public final boolean marshalProcessInstances;
    public final boolean marshalWorkItems;
    public final Environment env;
    private final Map<Integer, Object> nodeMemories;
    private Object parameterObject;
    private ClassLoader classLoader;
    public Map<Integer, Map<TupleKey, PhreakTimerNode.Scheduler>> timerNodeSchedulers;

    public Map<Integer, Object> getNodeMemories() {
        return this.nodeMemories;
    }

    public ProtobufMarshallerReaderContext(InputStream stream, InternalKnowledgeBase kBase, Map<Integer, BaseNode> sinks, ObjectMarshallingStrategyStore resolverStrategyFactory, Map<Integer, TimersInputMarshaller> timerReaders, Environment env) throws IOException {
        this(stream, kBase, sinks, resolverStrategyFactory, timerReaders, true, true, env);
    }

    public ProtobufMarshallerReaderContext(InputStream stream, InternalKnowledgeBase kBase, Map<Integer, BaseNode> sinks, ObjectMarshallingStrategyStore resolverStrategyFactory, Map<Integer, TimersInputMarshaller> timerReaders, boolean marshalProcessInstances, boolean marshalWorkItems, Environment env) throws IOException {
        super(stream);
        this.kBase = kBase;
        this.sinks = sinks;
        this.readersByInt = timerReaders;
        this.handles = new HashMap<Long, InternalFactHandle>();
        this.rightTuples = new HashMap<RightTupleKey, RightTuple>();
        this.terminalTupleMap = new HashMap<Integer, LeftTuple>();
        this.filter = new ProtobufInputMarshaller.PBActivationsFilter();
        this.entryPoints = new HashMap<String, EntryPointId>();
        this.propagationContexts = new HashMap<Long, PropagationContext>();
        if (resolverStrategyFactory == null) {
            ObjectMarshallingStrategy[] strats = (ObjectMarshallingStrategy[])env.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
            if (strats == null) {
                strats = this.getMarshallingStrategy();
            }
            this.resolverStrategyFactory = new ObjectMarshallingStrategyStoreImpl(strats);
        } else {
            this.resolverStrategyFactory = resolverStrategyFactory;
        }
        this.usedStrategies = new HashMap<Integer, ObjectMarshallingStrategy>();
        this.strategyContexts = new HashMap<ObjectMarshallingStrategy, ObjectMarshallingStrategy.Context>();
        this.marshalProcessInstances = marshalProcessInstances;
        this.marshalWorkItems = marshalWorkItems;
        this.env = env;
        this.nodeMemories = new HashMap<Integer, Object>();
        this.timerNodeSchedulers = new HashMap<Integer, Map<TupleKey, PhreakTimerNode.Scheduler>>();
        this.parameterObject = null;
    }

    protected ObjectMarshallingStrategy[] getMarshallingStrategy() {
        return new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()};
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        try {
            if (this.classLoader == null && this.kBase != null) {
                this.classLoader = this.kBase.getRootClassLoader();
            }
            return Class.forName(name, false, this.classLoader);
        }
        catch (ClassNotFoundException ex) {
            return super.resolveClass(desc);
        }
    }

    public void addTimerNodeScheduler(int nodeId, TupleKey key, PhreakTimerNode.Scheduler scheduler) {
        Map<TupleKey, PhreakTimerNode.Scheduler> timers = this.timerNodeSchedulers.get(nodeId);
        if (timers == null) {
            timers = new HashMap<TupleKey, PhreakTimerNode.Scheduler>();
            this.timerNodeSchedulers.put(nodeId, timers);
        }
        timers.put(key, scheduler);
    }

    public PhreakTimerNode.Scheduler removeTimerNodeScheduler(int nodeId, TupleKey key) {
        Map<TupleKey, PhreakTimerNode.Scheduler> timers = this.timerNodeSchedulers.get(nodeId);
        if (timers != null) {
            PhreakTimerNode.Scheduler scheduler = timers.remove(key);
            if (timers.isEmpty()) {
                this.timerNodeSchedulers.remove(nodeId);
            }
            return scheduler;
        }
        return null;
    }

    public InternalWorkingMemory getWorkingMemory() {
        return this.wm;
    }

    public void setWorkingMemory(InternalWorkingMemory wm) {
        this.wm = wm;
    }

    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    public Map<Long, InternalFactHandle> getHandles() {
        return this.handles;
    }

    public Map<Integer, LeftTuple> getTerminalTupleMap() {
        return this.terminalTupleMap;
    }

    public ProtobufInputMarshaller.PBActivationsFilter getFilter() {
        return this.filter;
    }

    public Map<Integer, BaseNode> getSinks() {
        return this.sinks;
    }

    public Map<Long, PropagationContext> getPropagationContexts() {
        return this.propagationContexts;
    }

    public ObjectMarshallingStrategyStore getResolverStrategyFactory() {
        return this.resolverStrategyFactory;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Map<Integer, ObjectMarshallingStrategy> getUsedStrategies() {
        return this.usedStrategies;
    }

    public Map<ObjectMarshallingStrategy, ObjectMarshallingStrategy.Context> getStrategyContexts() {
        return this.strategyContexts;
    }

    public Object getParameterObject() {
        return this.parameterObject;
    }

    public void setParameterObject(Object parameterObject) {
        this.parameterObject = parameterObject;
    }

    public Object getReaderForInt(int i) {
        return this.readersByInt.get(i);
    }

    public void setReaderForInt(int i, Object reader) {
        this.readersByInt.put(i, (TimersInputMarshaller)reader);
    }

    public InternalFactHandle createAccumulateHandle(EntryPointId entryPointId, ReteEvaluator reteEvaluator, TupleImpl leftTuple, Object result, int nodeId) {
        InternalFactHandle handle = null;
        ProtobufMessages.FactHandle _handle = null;
        Map map = (Map)this.getNodeMemories().get(nodeId);
        if (map != null) {
            _handle = (ProtobufMessages.FactHandle)map.get(TupleKey.createTupleKey((TupleImpl)leftTuple));
        }
        if (_handle != null) {
            handle = reteEvaluator.getFactHandleFactory().newFactHandle(_handle.getId(), result, _handle.getRecency(), reteEvaluator.getDefaultEntryPoint().getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(entryPointId, result), reteEvaluator, null);
        }
        return handle;
    }

    public InternalFactHandle createAsyncNodeHandle(TupleImpl leftTuple, ReteEvaluator reteEvaluator, Object object, int nodeId, ObjectTypeConf objectTypeConf) {
        TupleKey key;
        List list;
        ProtobufMessages.FactHandle _handle = null;
        Map map = (Map)this.getNodeMemories().get(nodeId);
        if (map != null && (list = (List)map.get(key = TupleKey.createTupleKey((TupleImpl)leftTuple))) != null && !list.isEmpty()) {
            _handle = (ProtobufMessages.FactHandle)((LinkedList)list).removeFirst();
            if (list.isEmpty()) {
                map.remove(key);
            }
        }
        InternalFactHandle handle = null;
        if (_handle != null) {
            handle = reteEvaluator.getFactHandleFactory().newFactHandle(_handle.getId(), object, _handle.getRecency(), objectTypeConf, reteEvaluator, null);
        }
        return handle;
    }

    public QueryElementFactHandle createQueryResultHandle(TupleImpl leftTuple, Object[] objects, int nodeId) {
        ProtobufInputMarshaller.QueryElementContext queryElementContext;
        ProtobufMessages.FactHandle handle = null;
        Map map = (Map)this.getNodeMemories().get(nodeId);
        if (map != null && (queryElementContext = (ProtobufInputMarshaller.QueryElementContext)map.get(TupleKey.createTupleKey((TupleImpl)leftTuple))) != null) {
            handle = queryElementContext.results.removeFirst();
        }
        return handle != null ? new QueryElementFactHandle((Object)objects, handle.getId(), handle.getRecency()) : null;
    }

    public InternalFactHandle createQueryHandle(TupleImpl leftTuple, ReteEvaluator reteEvaluator, int nodeId) {
        ProtobufMessages.FactHandle handle = null;
        Map map = (Map)this.getNodeMemories().get(nodeId);
        if (map != null) {
            handle = ((ProtobufInputMarshaller.QueryElementContext)map.get((Object)TupleKey.createTupleKey((TupleImpl)leftTuple))).handle;
        }
        return handle != null ? reteEvaluator.getFactHandleFactory().newFactHandle(handle.getId(), null, handle.getRecency(), null, reteEvaluator, null) : null;
    }

    public void withSerializedNodeMemories() {
        this.filter.withSerializedNodeMemories();
    }
}

