/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import org.drools.common.InternalFactHandle;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleMemory;
import org.drools.util.AbstractHashTable;
import org.drools.util.Entry;
import org.drools.util.Iterator;

public class TupleHashTable
extends AbstractHashTable
implements TupleMemory {
    public TupleHashTable() {
        this(16, 0.75f);
    }

    public TupleHashTable(int capacity, float loadFactor) {
        super(capacity, loadFactor);
    }

    public Iterator iterator(InternalFactHandle handle) {
        return this.iterator();
    }

    public void add(ReteTuple tuple) {
        int hashCode = tuple.hashCode();
        int index = this.indexOf(hashCode, this.table.length);
        tuple.setNext(this.table[index]);
        this.table[index] = tuple;
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    public ReteTuple get(ReteTuple tuple) {
        int hashCode = tuple.hashCode();
        int index = this.indexOf(hashCode, this.table.length);
        for (ReteTuple current = (ReteTuple)this.table[index]; current != null; current = (ReteTuple)current.getNext()) {
            if (hashCode != current.hashCode() || !tuple.equals(current)) continue;
            return current;
        }
        return null;
    }

    public ReteTuple remove(ReteTuple tuple) {
        ReteTuple previous;
        int hashCode = tuple.hashCode();
        int index = this.indexOf(hashCode, this.table.length);
        ReteTuple current = previous = (ReteTuple)this.table[index];
        while (current != null) {
            ReteTuple next = (ReteTuple)current.getNext();
            if (hashCode == current.hashCode() && tuple.equals(current)) {
                if (previous == current) {
                    this.table[index] = next;
                } else {
                    previous.setNext(next);
                }
                current.setNext(null);
                --this.size;
                return current;
            }
            previous = current;
            current = next;
        }
        return current;
    }

    public Entry getBucket(Object object) {
        int hashCode = object.hashCode();
        int index = this.indexOf(hashCode, this.table.length);
        return this.table[index];
    }

    public boolean contains(ReteTuple tuple) {
        return this.get(tuple) != null;
    }

    public boolean isIndexed() {
        return false;
    }
}

