/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class ShadowProxyUtils {
    private static final Class UNMODIFIABLE_MAP = Collections.unmodifiableMap(Collections.EMPTY_MAP).getClass();
    private static final Class UNMODIFIABLE_COLLECTION = Collections.unmodifiableCollection(Collections.EMPTY_LIST).getClass();

    private ShadowProxyUtils() {
    }

    public static Object cloneObject(Object original) {
        Object clone = null;
        if (original instanceof Cloneable) {
            try {
                Method cloneMethod = original.getClass().getMethod("clone", new Class[0]);
                clone = cloneMethod.invoke(original, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (clone == null) {
            try {
                if (original instanceof Map && original != Collections.EMPTY_MAP && !UNMODIFIABLE_MAP.isAssignableFrom(original.getClass())) {
                    clone = original.getClass().newInstance();
                    ((Map)clone).putAll((Map)original);
                } else if (original instanceof Collection && original != Collections.EMPTY_LIST && original != Collections.EMPTY_SET && !UNMODIFIABLE_COLLECTION.isAssignableFrom(original.getClass())) {
                    clone = original.getClass().newInstance();
                    ((Collection)clone).addAll((Collection)original);
                } else if (original.getClass().isArray()) {
                    clone = ShadowProxyUtils.cloneArray(original);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (clone == null) {
            clone = original;
        }
        return clone;
    }

    public static Object cloneArray(Object original) {
        Object result = null;
        if (original.getClass().isArray()) {
            int arrayLength = Array.getLength(original);
            if (arrayLength == 0) {
                result = original;
            } else {
                Class<?> componentType = original.getClass().getComponentType();
                result = Array.newInstance(componentType, arrayLength);
                if (componentType.isArray()) {
                    for (int i = 0; i < arrayLength; ++i) {
                        Array.set(result, i, ShadowProxyUtils.cloneArray(Array.get(original, i)));
                    }
                } else {
                    System.arraycopy(original, 0, result, 0, arrayLength);
                }
            }
        }
        return result;
    }
}

